
                                                    

package io.fabric8.openshift.client.handlers.ingress.operator;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.openshift.client.dsl.internal.ingress.operator.DNSRecordOperationsImpl;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.operator.v1.DNSRecord;
import io.fabric8.openshift.api.model.operator.v1.DNSRecordBuilder;

public class DNSRecordHandler implements ResourceHandler<DNSRecord, DNSRecordBuilder> {

  @Override
  public String getKind() {
    return DNSRecord.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "ingress.operator.openshift.io/v1";
    }

  @Override
  public DNSRecordBuilder edit(DNSRecord item) {
    return new DNSRecordBuilder(item);
  }

  @Override
  public Resource<DNSRecord> resource(OkHttpClient client, Config config, String namespace, DNSRecord item) {
    return new DNSRecordOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
