
                                                    

package io.fabric8.openshift.client.handlers.machine;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.openshift.client.dsl.internal.machine.MachineSetOperationsImpl;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.machine.v1beta1.MachineSet;
import io.fabric8.openshift.api.model.machine.v1beta1.MachineSetBuilder;

public class MachineSetHandler implements ResourceHandler<MachineSet, MachineSetBuilder> {

  @Override
  public String getKind() {
    return MachineSet.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "machine.openshift.io/v1beta1";
    }

  @Override
  public MachineSetBuilder edit(MachineSet item) {
    return new MachineSetBuilder(item);
  }

  @Override
  public Resource<MachineSet> resource(OkHttpClient client, Config config, String namespace, MachineSet item) {
    return new MachineSetOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
