
                                                    

package io.fabric8.openshift.client.handlers.machineconfiguration;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.openshift.client.dsl.internal.machineconfiguration.ContainerRuntimeConfigOperationsImpl;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.machineconfig.v1.ContainerRuntimeConfig;
import io.fabric8.openshift.api.model.machineconfig.v1.ContainerRuntimeConfigBuilder;

public class ContainerRuntimeConfigHandler implements ResourceHandler<ContainerRuntimeConfig, ContainerRuntimeConfigBuilder> {

  @Override
  public String getKind() {
    return ContainerRuntimeConfig.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "machineconfiguration.openshift.io/v1";
    }

  @Override
  public ContainerRuntimeConfigBuilder edit(ContainerRuntimeConfig item) {
    return new ContainerRuntimeConfigBuilder(item);
  }

  @Override
  public Resource<ContainerRuntimeConfig> resource(OkHttpClient client, Config config, String namespace, ContainerRuntimeConfig item) {
    return new ContainerRuntimeConfigOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
