
                                                    

package io.fabric8.openshift.client.handlers.machineconfiguration;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.openshift.client.dsl.internal.machineconfiguration.KubeletConfigOperationsImpl;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.machineconfig.v1.KubeletConfig;
import io.fabric8.openshift.api.model.machineconfig.v1.KubeletConfigBuilder;

public class KubeletConfigHandler implements ResourceHandler<KubeletConfig, KubeletConfigBuilder> {

  @Override
  public String getKind() {
    return KubeletConfig.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "machineconfiguration.openshift.io/v1";
    }

  @Override
  public KubeletConfigBuilder edit(KubeletConfig item) {
    return new KubeletConfigBuilder(item);
  }

  @Override
  public Resource<KubeletConfig> resource(OkHttpClient client, Config config, String namespace, KubeletConfig item) {
    return new KubeletConfigOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
