
                                                    

package io.fabric8.openshift.client.handlers.monitoring.coreos;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.openshift.client.dsl.internal.monitoring.coreos.AlertmanagerOperationsImpl;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.monitoring.v1.Alertmanager;
import io.fabric8.openshift.api.model.monitoring.v1.AlertmanagerBuilder;

public class AlertmanagerHandler implements ResourceHandler<Alertmanager, AlertmanagerBuilder> {

  @Override
  public String getKind() {
    return Alertmanager.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "monitoring.coreos.com/v1";
    }

  @Override
  public AlertmanagerBuilder edit(Alertmanager item) {
    return new AlertmanagerBuilder(item);
  }

  @Override
  public Resource<Alertmanager> resource(OkHttpClient client, Config config, String namespace, Alertmanager item) {
    return new AlertmanagerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
