
                                                    

package io.fabric8.openshift.client.handlers.monitoring.coreos;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.openshift.client.dsl.internal.monitoring.coreos.PodMonitorOperationsImpl;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.monitoring.v1.PodMonitor;
import io.fabric8.openshift.api.model.monitoring.v1.PodMonitorBuilder;

public class PodMonitorHandler implements ResourceHandler<PodMonitor, PodMonitorBuilder> {

  @Override
  public String getKind() {
    return PodMonitor.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "monitoring.coreos.com/v1";
    }

  @Override
  public PodMonitorBuilder edit(PodMonitor item) {
    return new PodMonitorBuilder(item);
  }

  @Override
  public Resource<PodMonitor> resource(OkHttpClient client, Config config, String namespace, PodMonitor item) {
    return new PodMonitorOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
