
                                                    

package io.fabric8.openshift.client.handlers.monitoring.coreos;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.openshift.client.dsl.internal.monitoring.coreos.ProbeOperationsImpl;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.monitoring.v1.Probe;
import io.fabric8.openshift.api.model.monitoring.v1.ProbeBuilder;

public class ProbeHandler implements ResourceHandler<Probe, ProbeBuilder> {

  @Override
  public String getKind() {
    return Probe.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "monitoring.coreos.com/v1";
    }

  @Override
  public ProbeBuilder edit(Probe item) {
    return new ProbeBuilder(item);
  }

  @Override
  public Resource<Probe> resource(OkHttpClient client, Config config, String namespace, Probe item) {
    return new ProbeOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
