
                                                    

package io.fabric8.openshift.client.handlers.monitoring.coreos;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.openshift.client.dsl.internal.monitoring.coreos.ServiceMonitorOperationsImpl;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.monitoring.v1.ServiceMonitor;
import io.fabric8.openshift.api.model.monitoring.v1.ServiceMonitorBuilder;

public class ServiceMonitorHandler implements ResourceHandler<ServiceMonitor, ServiceMonitorBuilder> {

  @Override
  public String getKind() {
    return ServiceMonitor.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "monitoring.coreos.com/v1";
    }

  @Override
  public ServiceMonitorBuilder edit(ServiceMonitor item) {
    return new ServiceMonitorBuilder(item);
  }

  @Override
  public Resource<ServiceMonitor> resource(OkHttpClient client, Config config, String namespace, ServiceMonitor item) {
    return new ServiceMonitorOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
