
                                                    

package io.fabric8.openshift.client.handlers.network;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.openshift.client.dsl.internal.network.EgressNetworkPolicyOperationsImpl;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.EgressNetworkPolicy;
import io.fabric8.openshift.api.model.EgressNetworkPolicyBuilder;

public class EgressNetworkPolicyHandler implements ResourceHandler<EgressNetworkPolicy, EgressNetworkPolicyBuilder> {

  @Override
  public String getKind() {
    return EgressNetworkPolicy.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "network.openshift.io/v1";
    }

  @Override
  public EgressNetworkPolicyBuilder edit(EgressNetworkPolicy item) {
    return new EgressNetworkPolicyBuilder(item);
  }

  @Override
  public Resource<EgressNetworkPolicy> resource(OkHttpClient client, Config config, String namespace, EgressNetworkPolicy item) {
    return new EgressNetworkPolicyOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
