
                                                    

package io.fabric8.openshift.client.handlers.network;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.openshift.client.dsl.internal.network.HostSubnetOperationsImpl;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.HostSubnet;
import io.fabric8.openshift.api.model.HostSubnetBuilder;

public class HostSubnetHandler implements ResourceHandler<HostSubnet, HostSubnetBuilder> {

  @Override
  public String getKind() {
    return HostSubnet.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "network.openshift.io/v1";
    }

  @Override
  public HostSubnetBuilder edit(HostSubnet item) {
    return new HostSubnetBuilder(item);
  }

  @Override
  public Resource<HostSubnet> resource(OkHttpClient client, Config config, String namespace, HostSubnet item) {
    return new HostSubnetOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
