
                                                    

package io.fabric8.openshift.client.handlers.network;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.openshift.client.dsl.internal.network.NetNamespaceOperationsImpl;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.NetNamespace;
import io.fabric8.openshift.api.model.NetNamespaceBuilder;

public class NetNamespaceHandler implements ResourceHandler<NetNamespace, NetNamespaceBuilder> {

  @Override
  public String getKind() {
    return NetNamespace.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "network.openshift.io/v1";
    }

  @Override
  public NetNamespaceBuilder edit(NetNamespace item) {
    return new NetNamespaceBuilder(item);
  }

  @Override
  public Resource<NetNamespace> resource(OkHttpClient client, Config config, String namespace, NetNamespace item) {
    return new NetNamespaceOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
