
                                                    

package io.fabric8.openshift.client.handlers.network.operator;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.openshift.client.dsl.internal.network.operator.OperatorPKIOperationsImpl;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.miscellaneous.network.operator.v1.OperatorPKI;
import io.fabric8.openshift.api.model.miscellaneous.network.operator.v1.OperatorPKIBuilder;

public class OperatorPKIHandler implements ResourceHandler<OperatorPKI, OperatorPKIBuilder> {

  @Override
  public String getKind() {
    return OperatorPKI.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "network.operator.openshift.io/v1";
    }

  @Override
  public OperatorPKIBuilder edit(OperatorPKI item) {
    return new OperatorPKIBuilder(item);
  }

  @Override
  public Resource<OperatorPKI> resource(OkHttpClient client, Config config, String namespace, OperatorPKI item) {
    return new OperatorPKIOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
