
                                                    

package io.fabric8.openshift.client.handlers.oauth;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.openshift.client.dsl.internal.oauth.OAuthAccessTokenOperationsImpl;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.OAuthAccessToken;
import io.fabric8.openshift.api.model.OAuthAccessTokenBuilder;

public class OAuthAccessTokenHandler implements ResourceHandler<OAuthAccessToken, OAuthAccessTokenBuilder> {

  @Override
  public String getKind() {
    return OAuthAccessToken.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "oauth.openshift.io/v1";
    }

  @Override
  public OAuthAccessTokenBuilder edit(OAuthAccessToken item) {
    return new OAuthAccessTokenBuilder(item);
  }

  @Override
  public Resource<OAuthAccessToken> resource(OkHttpClient client, Config config, String namespace, OAuthAccessToken item) {
    return new OAuthAccessTokenOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
