
                                                    

package io.fabric8.openshift.client.handlers.oauth;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.openshift.client.dsl.internal.oauth.OAuthAuthorizeTokenOperationsImpl;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.OAuthAuthorizeToken;
import io.fabric8.openshift.api.model.OAuthAuthorizeTokenBuilder;

public class OAuthAuthorizeTokenHandler implements ResourceHandler<OAuthAuthorizeToken, OAuthAuthorizeTokenBuilder> {

  @Override
  public String getKind() {
    return OAuthAuthorizeToken.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "oauth.openshift.io/v1";
    }

  @Override
  public OAuthAuthorizeTokenBuilder edit(OAuthAuthorizeToken item) {
    return new OAuthAuthorizeTokenBuilder(item);
  }

  @Override
  public Resource<OAuthAuthorizeToken> resource(OkHttpClient client, Config config, String namespace, OAuthAuthorizeToken item) {
    return new OAuthAuthorizeTokenOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
