
                                                    

package io.fabric8.openshift.client.handlers.oauth;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.openshift.client.dsl.internal.oauth.OAuthClientAuthorizationOperationsImpl;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.OAuthClientAuthorization;
import io.fabric8.openshift.api.model.OAuthClientAuthorizationBuilder;

public class OAuthClientAuthorizationHandler implements ResourceHandler<OAuthClientAuthorization, OAuthClientAuthorizationBuilder> {

  @Override
  public String getKind() {
    return OAuthClientAuthorization.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "oauth.openshift.io/v1";
    }

  @Override
  public OAuthClientAuthorizationBuilder edit(OAuthClientAuthorization item) {
    return new OAuthClientAuthorizationBuilder(item);
  }

  @Override
  public Resource<OAuthClientAuthorization> resource(OkHttpClient client, Config config, String namespace, OAuthClientAuthorization item) {
    return new OAuthClientAuthorizationOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
