
                                                    

package io.fabric8.openshift.client.handlers.operator;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.openshift.client.dsl.internal.operator.CloudCredentialOperationsImpl;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.operator.v1.CloudCredential;
import io.fabric8.openshift.api.model.operator.v1.CloudCredentialBuilder;

public class CloudCredentialHandler implements ResourceHandler<CloudCredential, CloudCredentialBuilder> {

  @Override
  public String getKind() {
    return CloudCredential.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "operator.openshift.io/v1";
    }

  @Override
  public CloudCredentialBuilder edit(CloudCredential item) {
    return new CloudCredentialBuilder(item);
  }

  @Override
  public Resource<CloudCredential> resource(OkHttpClient client, Config config, String namespace, CloudCredential item) {
    return new CloudCredentialOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
