
                                                    

package io.fabric8.openshift.client.handlers.operator;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.openshift.client.dsl.internal.operator.ClusterCSIDriverOperationsImpl;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.operator.v1.ClusterCSIDriver;
import io.fabric8.openshift.api.model.operator.v1.ClusterCSIDriverBuilder;

public class ClusterCSIDriverHandler implements ResourceHandler<ClusterCSIDriver, ClusterCSIDriverBuilder> {

  @Override
  public String getKind() {
    return ClusterCSIDriver.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "operator.openshift.io/v1";
    }

  @Override
  public ClusterCSIDriverBuilder edit(ClusterCSIDriver item) {
    return new ClusterCSIDriverBuilder(item);
  }

  @Override
  public Resource<ClusterCSIDriver> resource(OkHttpClient client, Config config, String namespace, ClusterCSIDriver item) {
    return new ClusterCSIDriverOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
