
                                                    

package io.fabric8.openshift.client.handlers.operator;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.openshift.client.dsl.internal.operator.ConsoleOperationsImpl;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.operator.v1.Console;
import io.fabric8.openshift.api.model.operator.v1.ConsoleBuilder;

public class ConsoleHandler implements ResourceHandler<Console, ConsoleBuilder> {

  @Override
  public String getKind() {
    return Console.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "operator.openshift.io/v1";
    }

  @Override
  public ConsoleBuilder edit(Console item) {
    return new ConsoleBuilder(item);
  }

  @Override
  public Resource<Console> resource(OkHttpClient client, Config config, String namespace, Console item) {
    return new ConsoleOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
