
                                                    

package io.fabric8.openshift.client.handlers.operator;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.openshift.client.dsl.internal.operator.DNSOperationsImpl;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.operator.v1.DNS;
import io.fabric8.openshift.api.model.operator.v1.DNSBuilder;

public class DNSHandler implements ResourceHandler<DNS, DNSBuilder> {

  @Override
  public String getKind() {
    return DNS.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "operator.openshift.io/v1";
    }

  @Override
  public DNSBuilder edit(DNS item) {
    return new DNSBuilder(item);
  }

  @Override
  public Resource<DNS> resource(OkHttpClient client, Config config, String namespace, DNS item) {
    return new DNSOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
