
                                                    

package io.fabric8.openshift.client.handlers.operator;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.openshift.client.dsl.internal.operator.ImageContentSourcePolicyOperationsImpl;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicy;
import io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicyBuilder;

public class ImageContentSourcePolicyHandler implements ResourceHandler<ImageContentSourcePolicy, ImageContentSourcePolicyBuilder> {

  @Override
  public String getKind() {
    return ImageContentSourcePolicy.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "operator.openshift.io/v1alpha1";
    }

  @Override
  public ImageContentSourcePolicyBuilder edit(ImageContentSourcePolicy item) {
    return new ImageContentSourcePolicyBuilder(item);
  }

  @Override
  public Resource<ImageContentSourcePolicy> resource(OkHttpClient client, Config config, String namespace, ImageContentSourcePolicy item) {
    return new ImageContentSourcePolicyOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
