
                                                    

package io.fabric8.openshift.client.handlers.operator;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.openshift.client.dsl.internal.operator.IngressControllerOperationsImpl;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.operator.v1.IngressController;
import io.fabric8.openshift.api.model.operator.v1.IngressControllerBuilder;

public class IngressControllerHandler implements ResourceHandler<IngressController, IngressControllerBuilder> {

  @Override
  public String getKind() {
    return IngressController.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "operator.openshift.io/v1";
    }

  @Override
  public IngressControllerBuilder edit(IngressController item) {
    return new IngressControllerBuilder(item);
  }

  @Override
  public Resource<IngressController> resource(OkHttpClient client, Config config, String namespace, IngressController item) {
    return new IngressControllerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
