
                                                    

package io.fabric8.openshift.client.handlers.operator;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.openshift.client.dsl.internal.operator.ServiceCAOperationsImpl;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.operator.v1.ServiceCA;
import io.fabric8.openshift.api.model.operator.v1.ServiceCABuilder;

public class ServiceCAHandler implements ResourceHandler<ServiceCA, ServiceCABuilder> {

  @Override
  public String getKind() {
    return ServiceCA.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "operator.openshift.io/v1";
    }

  @Override
  public ServiceCABuilder edit(ServiceCA item) {
    return new ServiceCABuilder(item);
  }

  @Override
  public Resource<ServiceCA> resource(OkHttpClient client, Config config, String namespace, ServiceCA item) {
    return new ServiceCAOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
