
                                                    

package io.fabric8.openshift.client.handlers.operator;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.openshift.client.dsl.internal.operator.ServiceCatalogControllerManagerOperationsImpl;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.operator.v1.ServiceCatalogControllerManager;
import io.fabric8.openshift.api.model.operator.v1.ServiceCatalogControllerManagerBuilder;

public class ServiceCatalogControllerManagerHandler implements ResourceHandler<ServiceCatalogControllerManager, ServiceCatalogControllerManagerBuilder> {

  @Override
  public String getKind() {
    return ServiceCatalogControllerManager.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "operator.openshift.io/v1";
    }

  @Override
  public ServiceCatalogControllerManagerBuilder edit(ServiceCatalogControllerManager item) {
    return new ServiceCatalogControllerManagerBuilder(item);
  }

  @Override
  public Resource<ServiceCatalogControllerManager> resource(OkHttpClient client, Config config, String namespace, ServiceCatalogControllerManager item) {
    return new ServiceCatalogControllerManagerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
