
                                                    

package io.fabric8.openshift.client.handlers.operator;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.openshift.client.dsl.internal.operator.StorageOperationsImpl;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.operator.v1.Storage;
import io.fabric8.openshift.api.model.operator.v1.StorageBuilder;

public class StorageHandler implements ResourceHandler<Storage, StorageBuilder> {

  @Override
  public String getKind() {
    return Storage.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "operator.openshift.io/v1";
    }

  @Override
  public StorageBuilder edit(Storage item) {
    return new StorageBuilder(item);
  }

  @Override
  public Resource<Storage> resource(OkHttpClient client, Config config, String namespace, Storage item) {
    return new StorageOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
