
                                                    

package io.fabric8.openshift.client.handlers.operators.coreos;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.openshift.client.dsl.internal.operators.coreos.CatalogSourceOperationsImpl;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.operatorhub.v1alpha1.CatalogSource;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.CatalogSourceBuilder;

public class CatalogSourceHandler implements ResourceHandler<CatalogSource, CatalogSourceBuilder> {

  @Override
  public String getKind() {
    return CatalogSource.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "operators.coreos.com/v1alpha1";
    }

  @Override
  public CatalogSourceBuilder edit(CatalogSource item) {
    return new CatalogSourceBuilder(item);
  }

  @Override
  public Resource<CatalogSource> resource(OkHttpClient client, Config config, String namespace, CatalogSource item) {
    return new CatalogSourceOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
