
                                                    

package io.fabric8.openshift.client.handlers.operators.coreos;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.openshift.client.dsl.internal.operators.coreos.InstallPlanOperationsImpl;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.operatorhub.v1alpha1.InstallPlan;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.InstallPlanBuilder;

public class InstallPlanHandler implements ResourceHandler<InstallPlan, InstallPlanBuilder> {

  @Override
  public String getKind() {
    return InstallPlan.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "operators.coreos.com/v1alpha1";
    }

  @Override
  public InstallPlanBuilder edit(InstallPlan item) {
    return new InstallPlanBuilder(item);
  }

  @Override
  public Resource<InstallPlan> resource(OkHttpClient client, Config config, String namespace, InstallPlan item) {
    return new InstallPlanOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
