
                                                    

package io.fabric8.openshift.client.handlers.operators.coreos;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.openshift.client.dsl.internal.operators.coreos.OperatorConditionOperationsImpl;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.operatorhub.v1.OperatorCondition;
import io.fabric8.openshift.api.model.operatorhub.v1.OperatorConditionBuilder;

public class OperatorConditionHandler implements ResourceHandler<OperatorCondition, OperatorConditionBuilder> {

  @Override
  public String getKind() {
    return OperatorCondition.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "operators.coreos.com/v1";
    }

  @Override
  public OperatorConditionBuilder edit(OperatorCondition item) {
    return new OperatorConditionBuilder(item);
  }

  @Override
  public Resource<OperatorCondition> resource(OkHttpClient client, Config config, String namespace, OperatorCondition item) {
    return new OperatorConditionOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
