
                                                    

package io.fabric8.openshift.client.handlers.operators.coreos;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.openshift.client.dsl.internal.operators.coreos.OperatorOperationsImpl;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.operatorhub.v1.Operator;
import io.fabric8.openshift.api.model.operatorhub.v1.OperatorBuilder;

public class OperatorHandler implements ResourceHandler<Operator, OperatorBuilder> {

  @Override
  public String getKind() {
    return Operator.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "operators.coreos.com/v1";
    }

  @Override
  public OperatorBuilder edit(Operator item) {
    return new OperatorBuilder(item);
  }

  @Override
  public Resource<Operator> resource(OkHttpClient client, Config config, String namespace, Operator item) {
    return new OperatorOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
