
                                                    

package io.fabric8.openshift.client.handlers.operators.coreos;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.openshift.client.dsl.internal.operators.coreos.SubscriptionOperationsImpl;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.operatorhub.v1alpha1.Subscription;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.SubscriptionBuilder;

public class SubscriptionHandler implements ResourceHandler<Subscription, SubscriptionBuilder> {

  @Override
  public String getKind() {
    return Subscription.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "operators.coreos.com/v1alpha1";
    }

  @Override
  public SubscriptionBuilder edit(Subscription item) {
    return new SubscriptionBuilder(item);
  }

  @Override
  public Resource<Subscription> resource(OkHttpClient client, Config config, String namespace, Subscription item) {
    return new SubscriptionOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
