
                                                    

package io.fabric8.openshift.client.handlers.packages.operators.coreos;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.openshift.client.dsl.internal.packages.operators.coreos.PackageManifestOperationsImpl;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.operatorhub.lifecyclemanager.v1.PackageManifest;
import io.fabric8.openshift.api.model.operatorhub.lifecyclemanager.v1.PackageManifestBuilder;

public class PackageManifestHandler implements ResourceHandler<PackageManifest, PackageManifestBuilder> {

  @Override
  public String getKind() {
    return PackageManifest.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "packages.operators.coreos.com/v1";
    }

  @Override
  public PackageManifestBuilder edit(PackageManifest item) {
    return new PackageManifestBuilder(item);
  }

  @Override
  public Resource<PackageManifest> resource(OkHttpClient client, Config config, String namespace, PackageManifest item) {
    return new PackageManifestOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
