
                                                    

package io.fabric8.openshift.client.handlers.project;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.openshift.client.dsl.internal.project.ProjectOperationsImpl;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.Project;
import io.fabric8.openshift.api.model.ProjectBuilder;

public class ProjectHandler implements ResourceHandler<Project, ProjectBuilder> {

  @Override
  public String getKind() {
    return Project.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "project.openshift.io/v1";
    }

  @Override
  public ProjectBuilder edit(Project item) {
    return new ProjectBuilder(item);
  }

  @Override
  public Resource<Project> resource(OkHttpClient client, Config config, String namespace, Project item) {
    return new ProjectOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
