
                                                    

package io.fabric8.openshift.client.handlers.security;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.openshift.client.dsl.internal.security.RangeAllocationOperationsImpl;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.RangeAllocation;
import io.fabric8.openshift.api.model.RangeAllocationBuilder;

public class RangeAllocationHandler implements ResourceHandler<RangeAllocation, RangeAllocationBuilder> {

  @Override
  public String getKind() {
    return RangeAllocation.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "security.openshift.io/v1";
    }

  @Override
  public RangeAllocationBuilder edit(RangeAllocation item) {
    return new RangeAllocationBuilder(item);
  }

  @Override
  public Resource<RangeAllocation> resource(OkHttpClient client, Config config, String namespace, RangeAllocation item) {
    return new RangeAllocationOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
