
                                                    

package io.fabric8.openshift.client.handlers.security;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.openshift.client.dsl.internal.security.SecurityContextConstraintsOperationsImpl;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.SecurityContextConstraints;
import io.fabric8.openshift.api.model.SecurityContextConstraintsBuilder;

public class SecurityContextConstraintsHandler implements ResourceHandler<SecurityContextConstraints, SecurityContextConstraintsBuilder> {

  @Override
  public String getKind() {
    return SecurityContextConstraints.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "security.openshift.io/v1";
    }

  @Override
  public SecurityContextConstraintsBuilder edit(SecurityContextConstraints item) {
    return new SecurityContextConstraintsBuilder(item);
  }

  @Override
  public Resource<SecurityContextConstraints> resource(OkHttpClient client, Config config, String namespace, SecurityContextConstraints item) {
    return new SecurityContextConstraintsOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
