
                                                    

package io.fabric8.openshift.client.handlers.template;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.openshift.client.dsl.internal.template.BrokerTemplateInstanceOperationsImpl;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.BrokerTemplateInstance;
import io.fabric8.openshift.api.model.BrokerTemplateInstanceBuilder;

public class BrokerTemplateInstanceHandler implements ResourceHandler<BrokerTemplateInstance, BrokerTemplateInstanceBuilder> {

  @Override
  public String getKind() {
    return BrokerTemplateInstance.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "template.openshift.io/v1";
    }

  @Override
  public BrokerTemplateInstanceBuilder edit(BrokerTemplateInstance item) {
    return new BrokerTemplateInstanceBuilder(item);
  }

  @Override
  public Resource<BrokerTemplateInstance> resource(OkHttpClient client, Config config, String namespace, BrokerTemplateInstance item) {
    return new BrokerTemplateInstanceOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
