
                                                    

package io.fabric8.openshift.client.handlers.tuned;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.openshift.client.dsl.internal.tuned.ProfileOperationsImpl;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.tuned.v1.Profile;
import io.fabric8.openshift.api.model.tuned.v1.ProfileBuilder;

public class ProfileHandler implements ResourceHandler<Profile, ProfileBuilder> {

  @Override
  public String getKind() {
    return Profile.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "tuned.openshift.io/v1";
    }

  @Override
  public ProfileBuilder edit(Profile item) {
    return new ProfileBuilder(item);
  }

  @Override
  public Resource<Profile> resource(OkHttpClient client, Config config, String namespace, Profile item) {
    return new ProfileOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
