
                                                    

package io.fabric8.openshift.client.handlers.tuned;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.openshift.client.dsl.internal.tuned.TunedOperationsImpl;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.tuned.v1.Tuned;
import io.fabric8.openshift.api.model.tuned.v1.TunedBuilder;

public class TunedHandler implements ResourceHandler<Tuned, TunedBuilder> {

  @Override
  public String getKind() {
    return Tuned.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "tuned.openshift.io/v1";
    }

  @Override
  public TunedBuilder edit(Tuned item) {
    return new TunedBuilder(item);
  }

  @Override
  public Resource<Tuned> resource(OkHttpClient client, Config config, String namespace, Tuned item) {
    return new TunedOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
