
                                                    

package io.fabric8.openshift.client.handlers.user;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.openshift.client.dsl.internal.user.GroupOperationsImpl;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.Group;
import io.fabric8.openshift.api.model.GroupBuilder;

public class GroupHandler implements ResourceHandler<Group, GroupBuilder> {

  @Override
  public String getKind() {
    return Group.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "user.openshift.io/v1";
    }

  @Override
  public GroupBuilder edit(Group item) {
    return new GroupBuilder(item);
  }

  @Override
  public Resource<Group> resource(OkHttpClient client, Config config, String namespace, Group item) {
    return new GroupOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
