
                                                    

package io.fabric8.openshift.client.handlers.user;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.openshift.client.dsl.internal.user.UserOperationsImpl;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.User;
import io.fabric8.openshift.api.model.UserBuilder;

public class UserHandler implements ResourceHandler<User, UserBuilder> {

  @Override
  public String getKind() {
    return User.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "user.openshift.io/v1";
    }

  @Override
  public UserBuilder edit(User item) {
    return new UserBuilder(item);
  }

  @Override
  public Resource<User> resource(OkHttpClient client, Config config, String namespace, User item) {
    return new UserOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
