/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.osgi;

import io.fabric8.kubernetes.api.model.ComponentStatus;
import io.fabric8.kubernetes.api.model.ComponentStatusList;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.client.Client;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.RequestConfig;
import io.fabric8.kubernetes.client.VersionInfo;
import io.fabric8.kubernetes.client.dsl.FunctionCallable;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.kubernetes.client.dsl.InOutCreateable;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.Nameable;
import io.fabric8.kubernetes.client.dsl.Namespaceable;
import io.fabric8.kubernetes.client.dsl.NamespacedInOutCreateable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ParameterMixedOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.osgi.NamespacedKubernetesClientAdapter;
import io.fabric8.kubernetes.client.utils.URLUtils;
import io.fabric8.openshift.api.model.BrokerTemplateInstance;
import io.fabric8.openshift.api.model.BrokerTemplateInstanceList;
import io.fabric8.openshift.api.model.Build;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.BuildConfigList;
import io.fabric8.openshift.api.model.BuildList;
import io.fabric8.openshift.api.model.ClusterNetwork;
import io.fabric8.openshift.api.model.ClusterNetworkList;
import io.fabric8.openshift.api.model.ClusterRole;
import io.fabric8.openshift.api.model.ClusterRoleBinding;
import io.fabric8.openshift.api.model.ClusterRoleBindingList;
import io.fabric8.openshift.api.model.ClusterRoleList;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.DeploymentConfigList;
import io.fabric8.openshift.api.model.EgressNetworkPolicy;
import io.fabric8.openshift.api.model.EgressNetworkPolicyList;
import io.fabric8.openshift.api.model.Group;
import io.fabric8.openshift.api.model.GroupList;
import io.fabric8.openshift.api.model.HelmChartRepository;
import io.fabric8.openshift.api.model.HelmChartRepositoryList;
import io.fabric8.openshift.api.model.HostSubnet;
import io.fabric8.openshift.api.model.HostSubnetList;
import io.fabric8.openshift.api.model.Identity;
import io.fabric8.openshift.api.model.IdentityList;
import io.fabric8.openshift.api.model.Image;
import io.fabric8.openshift.api.model.ImageList;
import io.fabric8.openshift.api.model.ImageStream;
import io.fabric8.openshift.api.model.ImageStreamImage;
import io.fabric8.openshift.api.model.ImageStreamImport;
import io.fabric8.openshift.api.model.ImageStreamList;
import io.fabric8.openshift.api.model.ImageStreamMapping;
import io.fabric8.openshift.api.model.ImageStreamTag;
import io.fabric8.openshift.api.model.ImageStreamTagList;
import io.fabric8.openshift.api.model.ImageTag;
import io.fabric8.openshift.api.model.ImageTagList;
import io.fabric8.openshift.api.model.LocalResourceAccessReview;
import io.fabric8.openshift.api.model.LocalSubjectAccessReview;
import io.fabric8.openshift.api.model.NetNamespace;
import io.fabric8.openshift.api.model.NetNamespaceList;
import io.fabric8.openshift.api.model.OAuthAccessToken;
import io.fabric8.openshift.api.model.OAuthAccessTokenList;
import io.fabric8.openshift.api.model.OAuthAuthorizeToken;
import io.fabric8.openshift.api.model.OAuthAuthorizeTokenList;
import io.fabric8.openshift.api.model.OAuthClient;
import io.fabric8.openshift.api.model.OAuthClientAuthorization;
import io.fabric8.openshift.api.model.OAuthClientAuthorizationList;
import io.fabric8.openshift.api.model.OAuthClientList;
import io.fabric8.openshift.api.model.PodSecurityPolicyReview;
import io.fabric8.openshift.api.model.PodSecurityPolicySelfSubjectReview;
import io.fabric8.openshift.api.model.PodSecurityPolicySubjectReview;
import io.fabric8.openshift.api.model.RangeAllocation;
import io.fabric8.openshift.api.model.RangeAllocationList;
import io.fabric8.openshift.api.model.ResourceAccessReview;
import io.fabric8.openshift.api.model.ResourceAccessReviewResponse;
import io.fabric8.openshift.api.model.Role;
import io.fabric8.openshift.api.model.RoleBinding;
import io.fabric8.openshift.api.model.RoleBindingList;
import io.fabric8.openshift.api.model.RoleBindingRestriction;
import io.fabric8.openshift.api.model.RoleBindingRestrictionList;
import io.fabric8.openshift.api.model.RoleList;
import io.fabric8.openshift.api.model.Route;
import io.fabric8.openshift.api.model.RouteList;
import io.fabric8.openshift.api.model.SecurityContextConstraints;
import io.fabric8.openshift.api.model.SecurityContextConstraintsList;
import io.fabric8.openshift.api.model.SelfSubjectRulesReview;
import io.fabric8.openshift.api.model.SubjectAccessReview;
import io.fabric8.openshift.api.model.SubjectAccessReviewResponse;
import io.fabric8.openshift.api.model.SubjectRulesReview;
import io.fabric8.openshift.api.model.Template;
import io.fabric8.openshift.api.model.TemplateInstance;
import io.fabric8.openshift.api.model.TemplateInstanceList;
import io.fabric8.openshift.api.model.TemplateList;
import io.fabric8.openshift.api.model.User;
import io.fabric8.openshift.api.model.UserIdentityMapping;
import io.fabric8.openshift.api.model.UserList;
import io.fabric8.openshift.api.model.UserOAuthAccessToken;
import io.fabric8.openshift.api.model.UserOAuthAccessTokenList;
import io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.APIRequestCount;
import io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.APIRequestCountList;
import io.fabric8.openshift.api.model.miscellaneous.cloudcredential.v1.CredentialsRequest;
import io.fabric8.openshift.api.model.miscellaneous.cloudcredential.v1.CredentialsRequestList;
import io.fabric8.openshift.api.model.miscellaneous.cncf.cni.v1.NetworkAttachmentDefinition;
import io.fabric8.openshift.api.model.miscellaneous.cncf.cni.v1.NetworkAttachmentDefinitionList;
import io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ConfigList;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.BareMetalHost;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.BareMetalHostList;
import io.fabric8.openshift.api.model.miscellaneous.network.operator.v1.EgressRouter;
import io.fabric8.openshift.api.model.miscellaneous.network.operator.v1.EgressRouterList;
import io.fabric8.openshift.api.model.miscellaneous.network.operator.v1.OperatorPKI;
import io.fabric8.openshift.api.model.miscellaneous.network.operator.v1.OperatorPKIList;
import io.fabric8.openshift.client.NamespacedOpenShiftClient;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.OpenShiftConfigBuilder;
import io.fabric8.openshift.client.dsl.BuildConfigResource;
import io.fabric8.openshift.client.dsl.BuildResource;
import io.fabric8.openshift.client.dsl.DeployableScalableResource;
import io.fabric8.openshift.client.dsl.MachineConfigurationAPIGroupDSL;
import io.fabric8.openshift.client.dsl.NameableCreateOrDeleteable;
import io.fabric8.openshift.client.dsl.OpenShiftClusterAutoscalingAPIGroupDSL;
import io.fabric8.openshift.client.dsl.OpenShiftConfigAPIGroupDSL;
import io.fabric8.openshift.client.dsl.OpenShiftConsoleAPIGroupDSL;
import io.fabric8.openshift.client.dsl.OpenShiftHiveAPIGroupDSL;
import io.fabric8.openshift.client.dsl.OpenShiftMachineAPIGroupDSL;
import io.fabric8.openshift.client.dsl.OpenShiftMonitoringAPIGroupDSL;
import io.fabric8.openshift.client.dsl.OpenShiftOperatorAPIGroupDSL;
import io.fabric8.openshift.client.dsl.OpenShiftOperatorHubAPIGroupDSL;
import io.fabric8.openshift.client.dsl.OpenShiftQuotaAPIGroupDSL;
import io.fabric8.openshift.client.dsl.OpenShiftStorageVersionMigratorApiGroupDSL;
import io.fabric8.openshift.client.dsl.OpenShiftTunedAPIGroupDSL;
import io.fabric8.openshift.client.dsl.OpenShiftWhereaboutsAPIGroupDSL;
import io.fabric8.openshift.client.dsl.ProjectOperation;
import io.fabric8.openshift.client.dsl.ProjectRequestOperation;
import io.fabric8.openshift.client.dsl.TemplateResource;
import java.net.URL;
import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Service;

@Component(configurationPid="io.fabric8.openshift.client", policy=ConfigurationPolicy.OPTIONAL)
@Service(value={OpenShiftClient.class, NamespacedOpenShiftClient.class})
public class ManagedOpenShiftClient
extends NamespacedKubernetesClientAdapter<NamespacedOpenShiftClient>
implements NamespacedOpenShiftClient {
    public ManagedOpenShiftClient() {
        super(NamespacedOpenShiftClient.class);
    }

    @Activate
    public void activate(Map<String, Object> properties) {
        OpenShiftConfigBuilder builder = new OpenShiftConfigBuilder();
        if (properties.containsKey("kubernetes.master")) {
            builder.withMasterUrl((String)properties.get("kubernetes.master"));
        }
        if (properties.containsKey("kubernetes.api.version")) {
            builder.withApiVersion((String)properties.get("kubernetes.api.version"));
        }
        if (properties.containsKey("kubernetes.namespace")) {
            builder.withNamespace((String)properties.get("kubernetes.namespace"));
        }
        if (properties.containsKey("kubernetes.certs.ca.file")) {
            builder.withCaCertFile((String)properties.get("kubernetes.certs.ca.file"));
        }
        if (properties.containsKey("kubernetes.certs.ca.data")) {
            builder.withCaCertData((String)properties.get("kubernetes.certs.ca.data"));
        }
        if (properties.containsKey("kubernetes.certs.client.file")) {
            builder.withClientCertFile((String)properties.get("kubernetes.certs.client.file"));
        }
        if (properties.containsKey("kubernetes.certs.client.data")) {
            builder.withClientCertData((String)properties.get("kubernetes.certs.client.data"));
        }
        if (properties.containsKey("kubernetes.certs.client.key.file")) {
            builder.withClientKeyFile((String)properties.get("kubernetes.certs.client.key.file"));
        }
        if (properties.containsKey("kubernetes.certs.client.key.data")) {
            builder.withClientKeyData((String)properties.get("kubernetes.certs.client.key.data"));
        }
        if (properties.containsKey("kubernetes.certs.client.key.algo")) {
            builder.withClientKeyAlgo((String)properties.get("kubernetes.certs.client.key.algo"));
        }
        if (properties.containsKey("kubernetes.certs.client.key.passphrase")) {
            builder.withClientKeyPassphrase((String)properties.get("kubernetes.certs.client.key.passphrase"));
        }
        if (properties.containsKey("kubernetes.auth.basic.username")) {
            builder.withUsername((String)properties.get("kubernetes.auth.basic.username"));
        }
        if (properties.containsKey("kubernetes.auth.basic.password")) {
            builder.withPassword((String)properties.get("kubernetes.auth.basic.password"));
        }
        if (properties.containsKey("kubernetes.auth.token")) {
            builder.withOauthToken((String)properties.get("kubernetes.auth.token"));
        }
        if (properties.containsKey("kubernetes.watch.reconnectInterval")) {
            builder.withWatchReconnectInterval(Integer.parseInt((String)properties.get("kubernetes.watch.reconnectInterval")));
        }
        if (properties.containsKey("kubernetes.watch.reconnectLimit")) {
            builder.withWatchReconnectLimit(Integer.parseInt((String)properties.get("kubernetes.watch.reconnectLimit")));
        }
        if (properties.containsKey("kubernetes.request.timeout")) {
            builder.withRequestTimeout(Integer.parseInt((String)properties.get("kubernetes.request.timeout")));
        }
        if (properties.containsKey("http.proxy")) {
            builder.withHttpProxy((String)properties.get("http.proxy"));
        }
        if (properties.containsKey("https.proxy")) {
            builder.withHttpsProxy((String)properties.get("https.proxy"));
        }
        if (properties.containsKey("no.proxy")) {
            String noProxyProperty = (String)properties.get("no.proxy");
            builder.withNoProxy(noProxyProperty.split(","));
        }
        if (properties.containsKey("openshift.url")) {
            builder.withOpenShiftUrl((String)properties.get("openshift.url"));
        } else {
            builder.withOpenShiftUrl(URLUtils.join((String[])new String[]{builder.getMasterUrl(), "oapi", builder.getOapiVersion()}));
        }
        if (properties.containsKey("openshift.build.timeout")) {
            builder.withBuildTimeout((long)Integer.parseInt((String)properties.get("openshift.build.timeout")));
        } else {
            builder.withBuildTimeout(OpenShiftConfig.DEFAULT_BUILD_TIMEOUT.longValue());
        }
        if (properties.containsKey("kubernetes.websocket.timeout")) {
            builder.withWebsocketTimeout(Long.parseLong((String)properties.get("kubernetes.websocket.timeout")));
        }
        if (properties.containsKey("kubernetes.websocket.ping.interval")) {
            builder.withWebsocketPingInterval(Long.parseLong((String)properties.get("kubernetes.websocket.ping.interval")));
        }
        NamespacedOpenShiftClient delegate = (NamespacedOpenShiftClient)new KubernetesClientBuilder().withConfig((Config)builder.build()).build().adapt(NamespacedOpenShiftClient.class);
        this.init((Client)delegate);
    }

    @Deactivate
    public void deactivate() {
        ((NamespacedOpenShiftClient)this.getClient()).close();
    }

    public URL getOpenshiftUrl() {
        return ((NamespacedOpenShiftClient)this.getClient()).getOpenshiftUrl();
    }

    public OpenShiftConfigAPIGroupDSL config() {
        return ((NamespacedOpenShiftClient)this.getClient()).config();
    }

    public OpenShiftConsoleAPIGroupDSL console() {
        return ((NamespacedOpenShiftClient)this.getClient()).console();
    }

    public OpenShiftClusterAutoscalingAPIGroupDSL clusterAutoscaling() {
        return ((NamespacedOpenShiftClient)this.getClient()).clusterAutoscaling();
    }

    public OpenShiftHiveAPIGroupDSL hive() {
        return ((NamespacedOpenShiftClient)this.getClient()).hive();
    }

    public OpenShiftOperatorAPIGroupDSL operator() {
        return ((NamespacedOpenShiftClient)this.getClient()).operator();
    }

    public OpenShiftOperatorHubAPIGroupDSL operatorHub() {
        return ((NamespacedOpenShiftClient)this.getClient()).operatorHub();
    }

    public MixedOperation<Build, BuildList, BuildResource> builds() {
        return ((NamespacedOpenShiftClient)this.getClient()).builds();
    }

    public NonNamespaceOperation<ComponentStatus, ComponentStatusList, Resource<ComponentStatus>> componentstatuses() {
        return ((NamespacedOpenShiftClient)this.getClient()).componentstatuses();
    }

    public MixedOperation<BuildConfig, BuildConfigList, BuildConfigResource<BuildConfig, Void, Build>> buildConfigs() {
        return ((NamespacedOpenShiftClient)this.getClient()).buildConfigs();
    }

    public MixedOperation<CredentialsRequest, CredentialsRequestList, Resource<CredentialsRequest>> credentialsRequests() {
        return ((NamespacedOpenShiftClient)this.getClient()).credentialsRequests();
    }

    public MixedOperation<DeploymentConfig, DeploymentConfigList, DeployableScalableResource<DeploymentConfig>> deploymentConfigs() {
        return ((NamespacedOpenShiftClient)this.getClient()).deploymentConfigs();
    }

    public NonNamespaceOperation<Group, GroupList, Resource<Group>> groups() {
        return ((NamespacedOpenShiftClient)this.getClient()).groups();
    }

    public NonNamespaceOperation<HelmChartRepository, HelmChartRepositoryList, Resource<HelmChartRepository>> helmChartRepositories() {
        return ((NamespacedOpenShiftClient)this.getClient()).helmChartRepositories();
    }

    public NonNamespaceOperation<Image, ImageList, Resource<Image>> images() {
        return ((NamespacedOpenShiftClient)this.getClient()).images();
    }

    public MixedOperation<ImageTag, ImageTagList, Resource<ImageTag>> imageTags() {
        return ((NamespacedOpenShiftClient)this.getClient()).imageTags();
    }

    public MixedOperation<ImageStream, ImageStreamList, Resource<ImageStream>> imageStreams() {
        return ((NamespacedOpenShiftClient)this.getClient()).imageStreams();
    }

    public MixedOperation<ImageStreamTag, ImageStreamTagList, Resource<ImageStreamTag>> imageStreamTags() {
        return ((NamespacedOpenShiftClient)this.getClient()).imageStreamTags();
    }

    public NamespacedInOutCreateable<ImageStreamImport, ImageStreamImport> imageStreamImports() {
        return ((NamespacedOpenShiftClient)this.getClient()).imageStreamImports();
    }

    public NamespacedInOutCreateable<ImageStreamMapping, ImageStreamMapping> imageStreamMappings() {
        return ((NamespacedOpenShiftClient)this.getClient()).imageStreamMappings();
    }

    public Namespaceable<Nameable<? extends Gettable<ImageStreamImage>>> imageStreamImages() {
        return ((NamespacedOpenShiftClient)this.getClient()).imageStreamImages();
    }

    public NameableCreateOrDeleteable imageSignatures() {
        return ((NamespacedOpenShiftClient)this.getClient()).imageSignatures();
    }

    public NonNamespaceOperation<io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.Config, ConfigList, Resource<io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.Config>> imageRegistryOperatorConfigs() {
        return ((NamespacedOpenShiftClient)this.getClient()).imageRegistryOperatorConfigs();
    }

    public MixedOperation<NetworkAttachmentDefinition, NetworkAttachmentDefinitionList, Resource<NetworkAttachmentDefinition>> networkAttachmentDefinitions() {
        return ((NamespacedOpenShiftClient)this.getClient()).networkAttachmentDefinitions();
    }

    public NonNamespaceOperation<OAuthAccessToken, OAuthAccessTokenList, Resource<OAuthAccessToken>> oAuthAccessTokens() {
        return ((NamespacedOpenShiftClient)this.getClient()).oAuthAccessTokens();
    }

    public NonNamespaceOperation<OAuthAuthorizeToken, OAuthAuthorizeTokenList, Resource<OAuthAuthorizeToken>> oAuthAuthorizeTokens() {
        return ((NamespacedOpenShiftClient)this.getClient()).oAuthAuthorizeTokens();
    }

    public NonNamespaceOperation<OAuthClient, OAuthClientList, Resource<OAuthClient>> oAuthClients() {
        return ((NamespacedOpenShiftClient)this.getClient()).oAuthClients();
    }

    public NamespacedInOutCreateable<PodSecurityPolicyReview, PodSecurityPolicyReview> podSecurityPolicyReviews() {
        return ((NamespacedOpenShiftClient)this.getClient()).podSecurityPolicyReviews();
    }

    public NonNamespaceOperation<OAuthClientAuthorization, OAuthClientAuthorizationList, Resource<OAuthClientAuthorization>> oAuthClientAuthorizations() {
        return ((NamespacedOpenShiftClient)this.getClient()).oAuthClientAuthorizations();
    }

    public MixedOperation<OperatorPKI, OperatorPKIList, Resource<OperatorPKI>> operatorPKIs() {
        return ((NamespacedOpenShiftClient)this.getClient()).operatorPKIs();
    }

    public MixedOperation<EgressRouter, EgressRouterList, Resource<EgressRouter>> egressRouters() {
        return ((NamespacedOpenShiftClient)this.getClient()).egressRouters();
    }

    public NamespacedInOutCreateable<PodSecurityPolicySelfSubjectReview, PodSecurityPolicySelfSubjectReview> podSecurityPolicySelfSubjectReviews() {
        return ((NamespacedOpenShiftClient)this.getClient()).podSecurityPolicySelfSubjectReviews();
    }

    public NamespacedInOutCreateable<PodSecurityPolicySubjectReview, PodSecurityPolicySubjectReview> podSecurityPolicySubjectReviews() {
        return ((NamespacedOpenShiftClient)this.getClient()).podSecurityPolicySubjectReviews();
    }

    public OpenShiftQuotaAPIGroupDSL quotas() {
        return ((NamespacedOpenShiftClient)this.getClient()).quotas();
    }

    public ProjectOperation projects() {
        return ((NamespacedOpenShiftClient)this.getClient()).projects();
    }

    public ProjectRequestOperation projectrequests() {
        return ((NamespacedOpenShiftClient)this.getClient()).projectrequests();
    }

    public MixedOperation<Role, RoleList, Resource<Role>> roles() {
        return ((NamespacedOpenShiftClient)this.getClient()).roles();
    }

    public MixedOperation<RoleBinding, RoleBindingList, Resource<RoleBinding>> roleBindings() {
        return ((NamespacedOpenShiftClient)this.getClient()).roleBindings();
    }

    public MixedOperation<Route, RouteList, Resource<Route>> routes() {
        return ((NamespacedOpenShiftClient)this.getClient()).routes();
    }

    public ParameterMixedOperation<Template, TemplateList, TemplateResource<Template, KubernetesList>> templates() {
        return ((NamespacedOpenShiftClient)this.getClient()).templates();
    }

    public MixedOperation<TemplateInstance, TemplateInstanceList, Resource<TemplateInstance>> templateInstances() {
        return ((NamespacedOpenShiftClient)this.getClient()).templateInstances();
    }

    public OpenShiftTunedAPIGroupDSL tuned() {
        return ((NamespacedOpenShiftClient)this.getClient()).tuned();
    }

    public NonNamespaceOperation<BrokerTemplateInstance, BrokerTemplateInstanceList, Resource<BrokerTemplateInstance>> brokerTemplateInstances() {
        return ((NamespacedOpenShiftClient)this.getClient()).brokerTemplateInstances();
    }

    public NonNamespaceOperation<User, UserList, Resource<User>> users() {
        return ((NamespacedOpenShiftClient)this.getClient()).users();
    }

    public MixedOperation<ClusterRoleBinding, ClusterRoleBindingList, Resource<ClusterRoleBinding>> clusterRoleBindings() {
        return ((NamespacedOpenShiftClient)this.getClient()).clusterRoleBindings();
    }

    public MixedOperation<RoleBindingRestriction, RoleBindingRestrictionList, Resource<RoleBindingRestriction>> roleBindingRestrictions() {
        return ((NamespacedOpenShiftClient)this.getClient()).roleBindingRestrictions();
    }

    public VersionInfo getOpenShiftV3Version() {
        return ((NamespacedOpenShiftClient)this.getClient()).getOpenShiftV3Version();
    }

    public String getOpenShiftV4Version() {
        return ((NamespacedOpenShiftClient)this.getClient()).getOpenShiftV4Version();
    }

    public MachineConfigurationAPIGroupDSL machineConfigurations() {
        return ((NamespacedOpenShiftClient)this.getClient()).machineConfigurations();
    }

    public OpenShiftMachineAPIGroupDSL machine() {
        return ((NamespacedOpenShiftClient)this.getClient()).machine();
    }

    public OpenShiftMonitoringAPIGroupDSL monitoring() {
        return ((NamespacedOpenShiftClient)this.getClient()).monitoring();
    }

    public NonNamespaceOperation<NetNamespace, NetNamespaceList, Resource<NetNamespace>> netNamespaces() {
        return ((NamespacedOpenShiftClient)this.getClient()).netNamespaces();
    }

    public NonNamespaceOperation<ClusterNetwork, ClusterNetworkList, Resource<ClusterNetwork>> clusterNetworks() {
        return ((NamespacedOpenShiftClient)this.getClient()).clusterNetworks();
    }

    public MixedOperation<EgressNetworkPolicy, EgressNetworkPolicyList, Resource<EgressNetworkPolicy>> egressNetworkPolicies() {
        return ((NamespacedOpenShiftClient)this.getClient()).egressNetworkPolicies();
    }

    public NonNamespaceOperation<HostSubnet, HostSubnetList, Resource<HostSubnet>> hostSubnets() {
        return ((NamespacedOpenShiftClient)this.getClient()).hostSubnets();
    }

    public NonNamespaceOperation<APIRequestCount, APIRequestCountList, Resource<APIRequestCount>> apiRequestCounts() {
        return ((NamespacedOpenShiftClient)this.getClient()).apiRequestCounts();
    }

    public MixedOperation<BareMetalHost, BareMetalHostList, Resource<BareMetalHost>> bareMetalHosts() {
        return ((NamespacedOpenShiftClient)this.getClient()).bareMetalHosts();
    }

    public InOutCreateable<SubjectAccessReview, SubjectAccessReviewResponse> subjectAccessReviews() {
        return ((NamespacedOpenShiftClient)this.getClient()).subjectAccessReviews();
    }

    public InOutCreateable<ResourceAccessReview, ResourceAccessReviewResponse> resourceAccessReviews() {
        return ((NamespacedOpenShiftClient)this.getClient()).resourceAccessReviews();
    }

    public NamespacedInOutCreateable<LocalSubjectAccessReview, SubjectAccessReviewResponse> localSubjectAccessReviews() {
        return ((NamespacedOpenShiftClient)this.getClient()).localSubjectAccessReviews();
    }

    public NamespacedInOutCreateable<LocalResourceAccessReview, ResourceAccessReviewResponse> localResourceAccessReviews() {
        return ((NamespacedOpenShiftClient)this.getClient()).localResourceAccessReviews();
    }

    public NamespacedInOutCreateable<SelfSubjectRulesReview, SelfSubjectRulesReview> selfSubjectRulesReviews() {
        return ((NamespacedOpenShiftClient)this.getClient()).selfSubjectRulesReviews();
    }

    public NamespacedInOutCreateable<SubjectRulesReview, SubjectRulesReview> subjectRulesReviews() {
        return ((NamespacedOpenShiftClient)this.getClient()).subjectRulesReviews();
    }

    public OpenShiftStorageVersionMigratorApiGroupDSL kubeStorageVersionMigrator() {
        return ((NamespacedOpenShiftClient)this.getClient()).kubeStorageVersionMigrator();
    }

    public NonNamespaceOperation<ClusterRole, ClusterRoleList, Resource<ClusterRole>> clusterRoles() {
        return ((NamespacedOpenShiftClient)this.getClient()).clusterRoles();
    }

    public FunctionCallable<NamespacedOpenShiftClient> withRequestConfig(RequestConfig requestConfig) {
        return ((NamespacedOpenShiftClient)this.getClient()).withRequestConfig(requestConfig);
    }

    public User currentUser() {
        return ((NamespacedOpenShiftClient)this.getClient()).currentUser();
    }

    public NonNamespaceOperation<Identity, IdentityList, Resource<Identity>> identities() {
        return ((NamespacedOpenShiftClient)this.getClient()).identities();
    }

    public InOutCreateable<UserIdentityMapping, UserIdentityMapping> userIdentityMappings() {
        return null;
    }

    public OpenShiftWhereaboutsAPIGroupDSL whereabouts() {
        return ((NamespacedOpenShiftClient)this.getClient()).whereabouts();
    }

    public boolean supportsOpenShiftAPIGroup(String apiGroup) {
        return ((NamespacedOpenShiftClient)this.getClient()).supportsOpenShiftAPIGroup(apiGroup);
    }

    public NonNamespaceOperation<RangeAllocation, RangeAllocationList, Resource<RangeAllocation>> rangeAllocations() {
        return ((NamespacedOpenShiftClient)this.getClient()).rangeAllocations();
    }

    public NonNamespaceOperation<SecurityContextConstraints, SecurityContextConstraintsList, Resource<SecurityContextConstraints>> securityContextConstraints() {
        return ((NamespacedOpenShiftClient)this.getClient()).securityContextConstraints();
    }

    public NonNamespaceOperation<UserOAuthAccessToken, UserOAuthAccessTokenList, Resource<UserOAuthAccessToken>> userOAuthAccessTokens() {
        return ((NamespacedOpenShiftClient)this.getClient()).userOAuthAccessTokens();
    }

    public boolean isSupported() {
        return ((NamespacedOpenShiftClient)this.getClient()).isSupported();
    }

    public ManagedOpenShiftClient newInstance() {
        return new ManagedOpenShiftClient();
    }

    public ManagedOpenShiftClient inAnyNamespace() {
        ManagedOpenShiftClient result = this.newInstance();
        result.init((Client)((NamespacedOpenShiftClient)this.getClient()).inAnyNamespace());
        return result;
    }

    public ManagedOpenShiftClient inNamespace(String namespace) {
        ManagedOpenShiftClient result = this.newInstance();
        result.init((Client)((NamespacedOpenShiftClient)this.getClient()).inNamespace(namespace));
        return result;
    }
}

