/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.dsl.internal.apps;

import io.fabric8.kubernetes.api.model.autoscaling.v1.Scale;
import io.fabric8.kubernetes.client.Client;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.KubernetesClientTimeoutException;
import io.fabric8.kubernetes.client.OperationInfo;
import io.fabric8.kubernetes.client.dsl.BytesLimitTerminateTimeTailPrettyLoggable;
import io.fabric8.kubernetes.client.dsl.LogWatch;
import io.fabric8.kubernetes.client.dsl.Loggable;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.PrettyLoggable;
import io.fabric8.kubernetes.client.dsl.TailPrettyLoggable;
import io.fabric8.kubernetes.client.dsl.TimeTailPrettyLoggable;
import io.fabric8.kubernetes.client.dsl.internal.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.internal.HasMetadataOperationsImpl;
import io.fabric8.kubernetes.client.dsl.internal.LogWatchCallback;
import io.fabric8.kubernetes.client.dsl.internal.OperationContext;
import io.fabric8.kubernetes.client.dsl.internal.PodOperationContext;
import io.fabric8.kubernetes.client.utils.URLUtils;
import io.fabric8.kubernetes.client.utils.internal.PodOperationUtil;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.DeploymentConfigList;
import io.fabric8.openshift.client.dsl.DeployableScalableResource;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeploymentConfigOperationsImpl
extends HasMetadataOperation<DeploymentConfig, DeploymentConfigList, DeployableScalableResource<DeploymentConfig>>
implements DeployableScalableResource<DeploymentConfig> {
    private static final Logger LOG = LoggerFactory.getLogger(DeploymentConfigOperationsImpl.class);
    private static final Integer DEFAULT_POD_LOG_WAIT_TIMEOUT = 5;
    public static final String OPENSHIFT_IO_DEPLOYMENT_CONFIG_NAME = "openshift.io/deployment-config.name";
    private final PodOperationContext rollingOperationContext;

    public DeploymentConfigOperationsImpl(Client client) {
        this(new PodOperationContext(), HasMetadataOperationsImpl.defaultContext((Client)client));
    }

    public DeploymentConfigOperationsImpl(PodOperationContext context, OperationContext superContext) {
        super(superContext.withApiGroupName("apps.openshift.io").withPlural("deploymentconfigs"), DeploymentConfig.class, DeploymentConfigList.class);
        this.rollingOperationContext = context;
    }

    public DeploymentConfigOperationsImpl newInstance(OperationContext context) {
        return new DeploymentConfigOperationsImpl(this.rollingOperationContext, context);
    }

    public DeploymentConfig deployLatest() {
        return this.deployLatest(false);
    }

    public DeploymentConfig deployLatest(boolean wait) {
        Long currentVersion = ((DeploymentConfig)this.getItemOrRequireFromServer()).getStatus().getLatestVersion();
        if (currentVersion == null) {
            currentVersion = 1L;
        }
        Long latestVersion = currentVersion + 1L;
        DeploymentConfig deployment = (DeploymentConfig)this.accept(d -> d.getStatus().setLatestVersion(latestVersion));
        if (wait) {
            this.waitUntilDeploymentConfigIsScaled(deployment.getSpec().getReplicas());
            deployment = (DeploymentConfig)this.getItemOrRequireFromServer();
        }
        return deployment;
    }

    public DeploymentConfig scale(int count) {
        return this.scale(count, false);
    }

    public DeploymentConfig scale(int count, boolean wait) {
        DeploymentConfig deployment = (DeploymentConfig)this.accept(d -> d.getSpec().setReplicas(Integer.valueOf(count)));
        if (wait) {
            this.waitUntilDeploymentConfigIsScaled(count);
            deployment = (DeploymentConfig)this.getItemOrRequireFromServer();
        }
        return deployment;
    }

    public Scale scale() {
        return this.handleScale(null);
    }

    public Scale scale(Scale scale) {
        return this.handleScale(scale);
    }

    private void waitUntilDeploymentConfigIsScaled(int count) {
        AtomicReference<Integer> replicasRef = new AtomicReference<Integer>(0);
        String name = this.checkName(this.getItem());
        String namespace = this.checkNamespace(this.getItem());
        try {
            this.waitUntilCondition(deploymentConfig -> {
                int currentReplicas;
                if (deploymentConfig == null) {
                    if (count == 0) {
                        return true;
                    }
                    throw new IllegalStateException("Can't wait for DeploymentConfig: " + this.checkName(this.getItem()) + " in namespace: " + this.checkName(this.getItem()) + " to scale. Resource is no longer available.");
                }
                replicasRef.set(deploymentConfig.getStatus().getReplicas());
                int n = currentReplicas = deploymentConfig.getStatus().getReplicas() != null ? deploymentConfig.getStatus().getReplicas() : 0;
                if (deploymentConfig.getStatus().getObservedGeneration() >= deploymentConfig.getMetadata().getGeneration() && Objects.equals(deploymentConfig.getSpec().getReplicas(), currentReplicas)) {
                    return true;
                }
                LOG.debug("Only {}/{} pods scheduled for DeploymentConfig: {} in namespace: {} seconds so waiting...", new Object[]{deploymentConfig.getStatus().getReplicas(), deploymentConfig.getSpec().getReplicas(), deploymentConfig.getMetadata().getName(), namespace});
                return false;
            }, this.getConfig().getScaleTimeout(), TimeUnit.MILLISECONDS);
            LOG.debug("{}/{} pod(s) ready for DeploymentConfig: {} in namespace: {}.", new Object[]{replicasRef.get(), count, name, namespace});
        }
        catch (KubernetesClientTimeoutException e) {
            LOG.error("{}/{} pod(s) ready for DeploymentConfig: {} in namespace: {}  after waiting for {} seconds so giving up", new Object[]{replicasRef.get(), count, name, namespace, TimeUnit.MILLISECONDS.toSeconds(this.getConfig().getScaleTimeout())});
        }
    }

    public String getLog() {
        return this.getLog(this.rollingOperationContext.isPrettyOutput());
    }

    public String getLog(boolean isPretty) {
        return new DeploymentConfigOperationsImpl(this.rollingOperationContext.withPrettyOutput(isPretty), this.context).doGetLog(String.class);
    }

    private <T> T doGetLog(Class<T> type) {
        try {
            URL url = this.getResourceLogUrl(false);
            return (T)this.handleRawGet(url, type);
        }
        catch (Throwable t) {
            throw KubernetesClientException.launderThrowable((OperationInfo)this.forOperationType("doGetLog"), (Throwable)t);
        }
    }

    public Reader getLogReader() {
        return this.doGetLog(Reader.class);
    }

    public InputStream getLogInputStream() {
        return this.doGetLog(InputStream.class);
    }

    public LogWatch watchLog() {
        return this.watchLog(null);
    }

    public LogWatch watchLog(OutputStream out) {
        try {
            this.waitUntilDeploymentConfigPodBecomesReady((DeploymentConfig)this.get());
            URL url = this.getResourceLogUrl(true);
            LogWatchCallback callback = new LogWatchCallback(out, this.context.getExecutor());
            return callback.callAndWait(this.httpClient, url);
        }
        catch (Throwable t) {
            throw KubernetesClientException.launderThrowable((OperationInfo)this.forOperationType("watchLog"), (Throwable)t);
        }
    }

    private URL getResourceLogUrl(Boolean follow) throws MalformedURLException {
        if (Boolean.TRUE.equals(follow)) {
            return new URL(URLUtils.join((String[])new String[]{this.getResourceUrl().toString(), this.rollingOperationContext.getLogParameters() + "&follow=true"}));
        }
        return new URL(URLUtils.join((String[])new String[]{this.getResourceUrl().toString(), this.rollingOperationContext.getLogParameters()}));
    }

    public Loggable withLogWaitTimeout(Integer logWaitTimeout) {
        return this.withReadyWaitTimeout(logWaitTimeout);
    }

    public Loggable withReadyWaitTimeout(Integer timeout) {
        return new DeploymentConfigOperationsImpl(this.rollingOperationContext.withReadyWaitTimeout(timeout), this.context);
    }

    private void waitUntilDeploymentConfigPodBecomesReady(DeploymentConfig deploymentConfig) {
        Integer podLogWaitTimeout = this.rollingOperationContext.getReadyWaitTimeout();
        List podOps = PodOperationUtil.getPodOperationsForController((OperationContext)this.context, (PodOperationContext)this.rollingOperationContext, (String)deploymentConfig.getMetadata().getUid(), DeploymentConfigOperationsImpl.getDeploymentConfigPodLabels(deploymentConfig));
        DeploymentConfigOperationsImpl.waitForBuildPodToBecomeReady(podOps, podLogWaitTimeout != null ? podLogWaitTimeout : DEFAULT_POD_LOG_WAIT_TIMEOUT);
    }

    private static void waitForBuildPodToBecomeReady(List<PodResource> podOps, Integer podLogWaitTimeout) {
        for (PodResource podOp : podOps) {
            PodOperationUtil.waitUntilReadyOrSucceded((PodResource)podOp, (Integer)podLogWaitTimeout);
        }
    }

    static Map<String, String> getDeploymentConfigPodLabels(DeploymentConfig deploymentConfig) {
        HashMap<String, String> labels = new HashMap<String, String>();
        if (deploymentConfig != null && deploymentConfig.getMetadata() != null) {
            labels.put(OPENSHIFT_IO_DEPLOYMENT_CONFIG_NAME, deploymentConfig.getMetadata().getName());
        }
        return labels;
    }

    public Loggable inContainer(String id) {
        return new DeploymentConfigOperationsImpl(this.rollingOperationContext.withContainerId(id), this.context);
    }

    public TimeTailPrettyLoggable limitBytes(int limitBytes) {
        return new DeploymentConfigOperationsImpl(this.rollingOperationContext.withLimitBytes(Integer.valueOf(limitBytes)), this.context);
    }

    public TimeTailPrettyLoggable terminated() {
        return new DeploymentConfigOperationsImpl(this.rollingOperationContext.withTerminatedStatus(true), this.context);
    }

    public Loggable withPrettyOutput() {
        return new DeploymentConfigOperationsImpl(this.rollingOperationContext.withPrettyOutput(true), this.context);
    }

    public PrettyLoggable tailingLines(int lines) {
        return new DeploymentConfigOperationsImpl(this.rollingOperationContext.withTailingLines(Integer.valueOf(lines)), this.context);
    }

    public TailPrettyLoggable sinceTime(String timestamp) {
        return new DeploymentConfigOperationsImpl(this.rollingOperationContext.withSinceTimestamp(timestamp), this.context);
    }

    public TailPrettyLoggable sinceSeconds(int seconds) {
        return new DeploymentConfigOperationsImpl(this.rollingOperationContext.withSinceSeconds(Integer.valueOf(seconds)), this.context);
    }

    public BytesLimitTerminateTimeTailPrettyLoggable usingTimestamps() {
        return new DeploymentConfigOperationsImpl(this.rollingOperationContext.withTimestamps(true), this.context);
    }
}

