package io.fabric8.openshift.api.model.autoscaling.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ClusterAutoscalerSpecBuilder extends ClusterAutoscalerSpecFluent<ClusterAutoscalerSpecBuilder> implements VisitableBuilder<ClusterAutoscalerSpec,ClusterAutoscalerSpecBuilder>{
  public ClusterAutoscalerSpecBuilder() {
    this(new ClusterAutoscalerSpec());
  }
  
  public ClusterAutoscalerSpecBuilder(ClusterAutoscalerSpecFluent<?> fluent) {
    this(fluent, new ClusterAutoscalerSpec());
  }
  
  public ClusterAutoscalerSpecBuilder(ClusterAutoscalerSpecFluent<?> fluent,ClusterAutoscalerSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ClusterAutoscalerSpecBuilder(ClusterAutoscalerSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ClusterAutoscalerSpecFluent<?> fluent;
  
  public ClusterAutoscalerSpec build() {
    ClusterAutoscalerSpec buildable = new ClusterAutoscalerSpec(fluent.getBalanceSimilarNodeGroups(),fluent.getBalancingIgnoredLabels(),fluent.getExpanders(),fluent.getIgnoreDaemonsetsUtilization(),fluent.getLogVerbosity(),fluent.getMaxNodeProvisionTime(),fluent.getMaxPodGracePeriod(),fluent.getPodPriorityThreshold(),fluent.buildResourceLimits(),fluent.buildScaleDown(),fluent.getSkipNodesWithLocalStorage());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}