/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.autoscaling.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.autoscaling.v1.ClusterAutoscalerSpecRLCores;
import io.fabric8.openshift.api.model.autoscaling.v1.ClusterAutoscalerSpecRLCoresBuilder;
import io.fabric8.openshift.api.model.autoscaling.v1.ClusterAutoscalerSpecRLCoresFluent;
import io.fabric8.openshift.api.model.autoscaling.v1.ClusterAutoscalerSpecRLGpus;
import io.fabric8.openshift.api.model.autoscaling.v1.ClusterAutoscalerSpecRLGpusBuilder;
import io.fabric8.openshift.api.model.autoscaling.v1.ClusterAutoscalerSpecRLGpusFluent;
import io.fabric8.openshift.api.model.autoscaling.v1.ClusterAutoscalerSpecRLMemory;
import io.fabric8.openshift.api.model.autoscaling.v1.ClusterAutoscalerSpecRLMemoryBuilder;
import io.fabric8.openshift.api.model.autoscaling.v1.ClusterAutoscalerSpecRLMemoryFluent;
import io.fabric8.openshift.api.model.autoscaling.v1.ClusterAutoscalerSpecResourceLimits;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class ClusterAutoscalerSpecResourceLimitsFluent<A extends ClusterAutoscalerSpecResourceLimitsFluent<A>>
extends BaseFluent<A> {
    private ClusterAutoscalerSpecRLCoresBuilder cores;
    private ArrayList<ClusterAutoscalerSpecRLGpusBuilder> gpus = new ArrayList();
    private Integer maxNodesTotal;
    private ClusterAutoscalerSpecRLMemoryBuilder memory;
    private Map<String, Object> additionalProperties;

    public ClusterAutoscalerSpecResourceLimitsFluent() {
    }

    public ClusterAutoscalerSpecResourceLimitsFluent(ClusterAutoscalerSpecResourceLimits instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ClusterAutoscalerSpecResourceLimits instance) {
        ClusterAutoscalerSpecResourceLimits clusterAutoscalerSpecResourceLimits = instance = instance != null ? instance : new ClusterAutoscalerSpecResourceLimits();
        if (instance != null) {
            this.withCores(instance.getCores());
            this.withGpus(instance.getGpus());
            this.withMaxNodesTotal(instance.getMaxNodesTotal());
            this.withMemory(instance.getMemory());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ClusterAutoscalerSpecRLCores buildCores() {
        return this.cores != null ? this.cores.build() : null;
    }

    public A withCores(ClusterAutoscalerSpecRLCores cores) {
        this._visitables.remove((Object)"cores");
        if (cores != null) {
            this.cores = new ClusterAutoscalerSpecRLCoresBuilder(cores);
            this._visitables.get((Object)"cores").add(this.cores);
        } else {
            this.cores = null;
            this._visitables.get((Object)"cores").remove((Object)this.cores);
        }
        return (A)((Object)this);
    }

    public boolean hasCores() {
        return this.cores != null;
    }

    public A withNewCores(Integer max, Integer min) {
        return this.withCores(new ClusterAutoscalerSpecRLCores(max, min));
    }

    public CoresNested<A> withNewCores() {
        return new CoresNested(null);
    }

    public CoresNested<A> withNewCoresLike(ClusterAutoscalerSpecRLCores item) {
        return new CoresNested(item);
    }

    public CoresNested<A> editCores() {
        return this.withNewCoresLike(Optional.ofNullable(this.buildCores()).orElse(null));
    }

    public CoresNested<A> editOrNewCores() {
        return this.withNewCoresLike(Optional.ofNullable(this.buildCores()).orElse(new ClusterAutoscalerSpecRLCoresBuilder().build()));
    }

    public CoresNested<A> editOrNewCoresLike(ClusterAutoscalerSpecRLCores item) {
        return this.withNewCoresLike(Optional.ofNullable(this.buildCores()).orElse(item));
    }

    public A addToGpus(int index, ClusterAutoscalerSpecRLGpus item) {
        if (this.gpus == null) {
            this.gpus = new ArrayList();
        }
        ClusterAutoscalerSpecRLGpusBuilder builder = new ClusterAutoscalerSpecRLGpusBuilder(item);
        if (index < 0 || index >= this.gpus.size()) {
            this._visitables.get((Object)"gpus").add(builder);
            this.gpus.add(builder);
        } else {
            this._visitables.get((Object)"gpus").add(index, builder);
            this.gpus.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToGpus(int index, ClusterAutoscalerSpecRLGpus item) {
        if (this.gpus == null) {
            this.gpus = new ArrayList();
        }
        ClusterAutoscalerSpecRLGpusBuilder builder = new ClusterAutoscalerSpecRLGpusBuilder(item);
        if (index < 0 || index >= this.gpus.size()) {
            this._visitables.get((Object)"gpus").add(builder);
            this.gpus.add(builder);
        } else {
            this._visitables.get((Object)"gpus").set(index, builder);
            this.gpus.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToGpus(ClusterAutoscalerSpecRLGpus ... items) {
        if (this.gpus == null) {
            this.gpus = new ArrayList();
        }
        for (ClusterAutoscalerSpecRLGpus item : items) {
            ClusterAutoscalerSpecRLGpusBuilder builder = new ClusterAutoscalerSpecRLGpusBuilder(item);
            this._visitables.get((Object)"gpus").add(builder);
            this.gpus.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToGpus(Collection<ClusterAutoscalerSpecRLGpus> items) {
        if (this.gpus == null) {
            this.gpus = new ArrayList();
        }
        for (ClusterAutoscalerSpecRLGpus item : items) {
            ClusterAutoscalerSpecRLGpusBuilder builder = new ClusterAutoscalerSpecRLGpusBuilder(item);
            this._visitables.get((Object)"gpus").add(builder);
            this.gpus.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromGpus(ClusterAutoscalerSpecRLGpus ... items) {
        if (this.gpus == null) {
            return (A)((Object)this);
        }
        for (ClusterAutoscalerSpecRLGpus item : items) {
            ClusterAutoscalerSpecRLGpusBuilder builder = new ClusterAutoscalerSpecRLGpusBuilder(item);
            this._visitables.get((Object)"gpus").remove((Object)builder);
            this.gpus.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromGpus(Collection<ClusterAutoscalerSpecRLGpus> items) {
        if (this.gpus == null) {
            return (A)((Object)this);
        }
        for (ClusterAutoscalerSpecRLGpus item : items) {
            ClusterAutoscalerSpecRLGpusBuilder builder = new ClusterAutoscalerSpecRLGpusBuilder(item);
            this._visitables.get((Object)"gpus").remove((Object)builder);
            this.gpus.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromGpus(Predicate<ClusterAutoscalerSpecRLGpusBuilder> predicate) {
        if (this.gpus == null) {
            return (A)((Object)this);
        }
        Iterator<ClusterAutoscalerSpecRLGpusBuilder> each = this.gpus.iterator();
        List visitables = this._visitables.get((Object)"gpus");
        while (each.hasNext()) {
            ClusterAutoscalerSpecRLGpusBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<ClusterAutoscalerSpecRLGpus> buildGpus() {
        return this.gpus != null ? ClusterAutoscalerSpecResourceLimitsFluent.build(this.gpus) : null;
    }

    public ClusterAutoscalerSpecRLGpus buildGpus(int index) {
        return this.gpus.get(index).build();
    }

    public ClusterAutoscalerSpecRLGpus buildFirstGpus() {
        return this.gpus.get(0).build();
    }

    public ClusterAutoscalerSpecRLGpus buildLastGpus() {
        return this.gpus.get(this.gpus.size() - 1).build();
    }

    public ClusterAutoscalerSpecRLGpus buildMatchingGpus(Predicate<ClusterAutoscalerSpecRLGpusBuilder> predicate) {
        for (ClusterAutoscalerSpecRLGpusBuilder item : this.gpus) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingGpus(Predicate<ClusterAutoscalerSpecRLGpusBuilder> predicate) {
        for (ClusterAutoscalerSpecRLGpusBuilder item : this.gpus) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withGpus(List<ClusterAutoscalerSpecRLGpus> gpus) {
        if (this.gpus != null) {
            this._visitables.get((Object)"gpus").clear();
        }
        if (gpus != null) {
            this.gpus = new ArrayList();
            for (ClusterAutoscalerSpecRLGpus item : gpus) {
                this.addToGpus(item);
            }
        } else {
            this.gpus = null;
        }
        return (A)((Object)this);
    }

    public A withGpus(ClusterAutoscalerSpecRLGpus ... gpus) {
        if (this.gpus != null) {
            this.gpus.clear();
            this._visitables.remove((Object)"gpus");
        }
        if (gpus != null) {
            for (ClusterAutoscalerSpecRLGpus item : gpus) {
                this.addToGpus(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasGpus() {
        return this.gpus != null && !this.gpus.isEmpty();
    }

    public A addNewGpus(Integer max, Integer min, String type) {
        return this.addToGpus(new ClusterAutoscalerSpecRLGpus(max, min, type));
    }

    public GpusNested<A> addNewGpus() {
        return new GpusNested(-1, null);
    }

    public GpusNested<A> addNewGpusLike(ClusterAutoscalerSpecRLGpus item) {
        return new GpusNested(-1, item);
    }

    public GpusNested<A> setNewGpusLike(int index, ClusterAutoscalerSpecRLGpus item) {
        return new GpusNested(index, item);
    }

    public GpusNested<A> editGpus(int index) {
        if (this.gpus.size() <= index) {
            throw new RuntimeException("Can't edit gpus. Index exceeds size.");
        }
        return this.setNewGpusLike(index, this.buildGpus(index));
    }

    public GpusNested<A> editFirstGpus() {
        if (this.gpus.size() == 0) {
            throw new RuntimeException("Can't edit first gpus. The list is empty.");
        }
        return this.setNewGpusLike(0, this.buildGpus(0));
    }

    public GpusNested<A> editLastGpus() {
        int index = this.gpus.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last gpus. The list is empty.");
        }
        return this.setNewGpusLike(index, this.buildGpus(index));
    }

    public GpusNested<A> editMatchingGpus(Predicate<ClusterAutoscalerSpecRLGpusBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.gpus.size(); ++i) {
            if (!predicate.test(this.gpus.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching gpus. No match found.");
        }
        return this.setNewGpusLike(index, this.buildGpus(index));
    }

    public Integer getMaxNodesTotal() {
        return this.maxNodesTotal;
    }

    public A withMaxNodesTotal(Integer maxNodesTotal) {
        this.maxNodesTotal = maxNodesTotal;
        return (A)((Object)this);
    }

    public boolean hasMaxNodesTotal() {
        return this.maxNodesTotal != null;
    }

    public ClusterAutoscalerSpecRLMemory buildMemory() {
        return this.memory != null ? this.memory.build() : null;
    }

    public A withMemory(ClusterAutoscalerSpecRLMemory memory) {
        this._visitables.remove((Object)"memory");
        if (memory != null) {
            this.memory = new ClusterAutoscalerSpecRLMemoryBuilder(memory);
            this._visitables.get((Object)"memory").add(this.memory);
        } else {
            this.memory = null;
            this._visitables.get((Object)"memory").remove((Object)this.memory);
        }
        return (A)((Object)this);
    }

    public boolean hasMemory() {
        return this.memory != null;
    }

    public A withNewMemory(Integer max, Integer min) {
        return this.withMemory(new ClusterAutoscalerSpecRLMemory(max, min));
    }

    public MemoryNested<A> withNewMemory() {
        return new MemoryNested(null);
    }

    public MemoryNested<A> withNewMemoryLike(ClusterAutoscalerSpecRLMemory item) {
        return new MemoryNested(item);
    }

    public MemoryNested<A> editMemory() {
        return this.withNewMemoryLike(Optional.ofNullable(this.buildMemory()).orElse(null));
    }

    public MemoryNested<A> editOrNewMemory() {
        return this.withNewMemoryLike(Optional.ofNullable(this.buildMemory()).orElse(new ClusterAutoscalerSpecRLMemoryBuilder().build()));
    }

    public MemoryNested<A> editOrNewMemoryLike(ClusterAutoscalerSpecRLMemory item) {
        return this.withNewMemoryLike(Optional.ofNullable(this.buildMemory()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClusterAutoscalerSpecResourceLimitsFluent that = (ClusterAutoscalerSpecResourceLimitsFluent)((Object)o);
        if (!Objects.equals((Object)this.cores, (Object)that.cores)) {
            return false;
        }
        if (!Objects.equals(this.gpus, that.gpus)) {
            return false;
        }
        if (!Objects.equals(this.maxNodesTotal, that.maxNodesTotal)) {
            return false;
        }
        if (!Objects.equals((Object)this.memory, (Object)that.memory)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.cores, this.gpus, this.maxNodesTotal, this.memory, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.cores != null) {
            sb.append("cores:");
            sb.append(this.cores + ",");
        }
        if (this.gpus != null && !this.gpus.isEmpty()) {
            sb.append("gpus:");
            sb.append(this.gpus + ",");
        }
        if (this.maxNodesTotal != null) {
            sb.append("maxNodesTotal:");
            sb.append(this.maxNodesTotal + ",");
        }
        if (this.memory != null) {
            sb.append("memory:");
            sb.append(this.memory + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class MemoryNested<N>
    extends ClusterAutoscalerSpecRLMemoryFluent<MemoryNested<N>>
    implements Nested<N> {
        ClusterAutoscalerSpecRLMemoryBuilder builder;

        MemoryNested(ClusterAutoscalerSpecRLMemory item) {
            this.builder = new ClusterAutoscalerSpecRLMemoryBuilder(this, item);
        }

        public N and() {
            return (N)ClusterAutoscalerSpecResourceLimitsFluent.this.withMemory(this.builder.build());
        }

        public N endMemory() {
            return this.and();
        }
    }

    public class GpusNested<N>
    extends ClusterAutoscalerSpecRLGpusFluent<GpusNested<N>>
    implements Nested<N> {
        ClusterAutoscalerSpecRLGpusBuilder builder;
        int index;

        GpusNested(int index, ClusterAutoscalerSpecRLGpus item) {
            this.index = index;
            this.builder = new ClusterAutoscalerSpecRLGpusBuilder(this, item);
        }

        public N and() {
            return (N)ClusterAutoscalerSpecResourceLimitsFluent.this.setToGpus(this.index, this.builder.build());
        }

        public N endGpus() {
            return this.and();
        }
    }

    public class CoresNested<N>
    extends ClusterAutoscalerSpecRLCoresFluent<CoresNested<N>>
    implements Nested<N> {
        ClusterAutoscalerSpecRLCoresBuilder builder;

        CoresNested(ClusterAutoscalerSpecRLCores item) {
            this.builder = new ClusterAutoscalerSpecRLCoresBuilder(this, item);
        }

        public N and() {
            return (N)ClusterAutoscalerSpecResourceLimitsFluent.this.withCores(this.builder.build());
        }

        public N endCores() {
            return this.and();
        }
    }
}

