package io.fabric8.openshift.api.model.clusterautoscaling.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class ClusterAutoscalerSpecBuilder extends io.fabric8.openshift.api.model.clusterautoscaling.v1.ClusterAutoscalerSpecFluentImpl<io.fabric8.openshift.api.model.clusterautoscaling.v1.ClusterAutoscalerSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.clusterautoscaling.v1.ClusterAutoscalerSpec,io.fabric8.openshift.api.model.clusterautoscaling.v1.ClusterAutoscalerSpecBuilder>{
  public ClusterAutoscalerSpecBuilder() {
    this(false);
  }
  public ClusterAutoscalerSpecBuilder(java.lang.Boolean validationEnabled) {
    this(new ClusterAutoscalerSpec(), validationEnabled);
  }
  public ClusterAutoscalerSpecBuilder(io.fabric8.openshift.api.model.clusterautoscaling.v1.ClusterAutoscalerSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterAutoscalerSpecBuilder(io.fabric8.openshift.api.model.clusterautoscaling.v1.ClusterAutoscalerSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ClusterAutoscalerSpec(), validationEnabled);
  }
  public ClusterAutoscalerSpecBuilder(io.fabric8.openshift.api.model.clusterautoscaling.v1.ClusterAutoscalerSpecFluent<?> fluent,io.fabric8.openshift.api.model.clusterautoscaling.v1.ClusterAutoscalerSpec instance) {
    this(fluent, instance, false);
  }
  public ClusterAutoscalerSpecBuilder(io.fabric8.openshift.api.model.clusterautoscaling.v1.ClusterAutoscalerSpecFluent<?> fluent,io.fabric8.openshift.api.model.clusterautoscaling.v1.ClusterAutoscalerSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withBalanceSimilarNodeGroups(instance.getBalanceSimilarNodeGroups()); 
    fluent.withIgnoreDaemonsetsUtilization(instance.getIgnoreDaemonsetsUtilization()); 
    fluent.withMaxNodeProvisionTime(instance.getMaxNodeProvisionTime()); 
    fluent.withMaxPodGracePeriod(instance.getMaxPodGracePeriod()); 
    fluent.withPodPriorityThreshold(instance.getPodPriorityThreshold()); 
    fluent.withResourceLimits(instance.getResourceLimits()); 
    fluent.withScaleDown(instance.getScaleDown()); 
    fluent.withSkipNodesWithLocalStorage(instance.getSkipNodesWithLocalStorage()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ClusterAutoscalerSpecBuilder(io.fabric8.openshift.api.model.clusterautoscaling.v1.ClusterAutoscalerSpec instance) {
    this(instance,false);
  }
  public ClusterAutoscalerSpecBuilder(io.fabric8.openshift.api.model.clusterautoscaling.v1.ClusterAutoscalerSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withBalanceSimilarNodeGroups(instance.getBalanceSimilarNodeGroups()); 
    this.withIgnoreDaemonsetsUtilization(instance.getIgnoreDaemonsetsUtilization()); 
    this.withMaxNodeProvisionTime(instance.getMaxNodeProvisionTime()); 
    this.withMaxPodGracePeriod(instance.getMaxPodGracePeriod()); 
    this.withPodPriorityThreshold(instance.getPodPriorityThreshold()); 
    this.withResourceLimits(instance.getResourceLimits()); 
    this.withScaleDown(instance.getScaleDown()); 
    this.withSkipNodesWithLocalStorage(instance.getSkipNodesWithLocalStorage()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.clusterautoscaling.v1.ClusterAutoscalerSpecFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.clusterautoscaling.v1.ClusterAutoscalerSpec build() {
    ClusterAutoscalerSpec buildable = new ClusterAutoscalerSpec(fluent.getBalanceSimilarNodeGroups(),fluent.getIgnoreDaemonsetsUtilization(),fluent.getMaxNodeProvisionTime(),fluent.getMaxPodGracePeriod(),fluent.getPodPriorityThreshold(),fluent.getResourceLimits(),fluent.getScaleDown(),fluent.getSkipNodesWithLocalStorage());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ClusterAutoscalerSpecBuilder that = (ClusterAutoscalerSpecBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}