package io.fabric8.openshift.api.model.clusterautoscaling.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class MachineAutoscalerSpecBuilder extends io.fabric8.openshift.api.model.clusterautoscaling.v1beta1.MachineAutoscalerSpecFluentImpl<io.fabric8.openshift.api.model.clusterautoscaling.v1beta1.MachineAutoscalerSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.clusterautoscaling.v1beta1.MachineAutoscalerSpec,io.fabric8.openshift.api.model.clusterautoscaling.v1beta1.MachineAutoscalerSpecBuilder>{
  public MachineAutoscalerSpecBuilder() {
    this(false);
  }
  public MachineAutoscalerSpecBuilder(java.lang.Boolean validationEnabled) {
    this(new MachineAutoscalerSpec(), validationEnabled);
  }
  public MachineAutoscalerSpecBuilder(io.fabric8.openshift.api.model.clusterautoscaling.v1beta1.MachineAutoscalerSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public MachineAutoscalerSpecBuilder(io.fabric8.openshift.api.model.clusterautoscaling.v1beta1.MachineAutoscalerSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new MachineAutoscalerSpec(), validationEnabled);
  }
  public MachineAutoscalerSpecBuilder(io.fabric8.openshift.api.model.clusterautoscaling.v1beta1.MachineAutoscalerSpecFluent<?> fluent,io.fabric8.openshift.api.model.clusterautoscaling.v1beta1.MachineAutoscalerSpec instance) {
    this(fluent, instance, false);
  }
  public MachineAutoscalerSpecBuilder(io.fabric8.openshift.api.model.clusterautoscaling.v1beta1.MachineAutoscalerSpecFluent<?> fluent,io.fabric8.openshift.api.model.clusterautoscaling.v1beta1.MachineAutoscalerSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withMaxReplicas(instance.getMaxReplicas()); 
    fluent.withMinReplicas(instance.getMinReplicas()); 
    fluent.withScaleTargetRef(instance.getScaleTargetRef()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public MachineAutoscalerSpecBuilder(io.fabric8.openshift.api.model.clusterautoscaling.v1beta1.MachineAutoscalerSpec instance) {
    this(instance,false);
  }
  public MachineAutoscalerSpecBuilder(io.fabric8.openshift.api.model.clusterautoscaling.v1beta1.MachineAutoscalerSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withMaxReplicas(instance.getMaxReplicas()); 
    this.withMinReplicas(instance.getMinReplicas()); 
    this.withScaleTargetRef(instance.getScaleTargetRef()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.clusterautoscaling.v1beta1.MachineAutoscalerSpecFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.clusterautoscaling.v1beta1.MachineAutoscalerSpec build() {
    MachineAutoscalerSpec buildable = new MachineAutoscalerSpec(fluent.getMaxReplicas(),fluent.getMinReplicas(),fluent.getScaleTargetRef());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    MachineAutoscalerSpecBuilder that = (MachineAutoscalerSpecBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}