package io.fabric8.openshift.api.model.clusterautoscaling.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class GPULimitBuilder extends GPULimitFluent<GPULimitBuilder> implements VisitableBuilder<GPULimit,GPULimitBuilder>{
  public GPULimitBuilder() {
    this(new GPULimit());
  }
  
  public GPULimitBuilder(GPULimitFluent<?> fluent) {
    this(fluent, new GPULimit());
  }
  
  public GPULimitBuilder(GPULimitFluent<?> fluent,GPULimit instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public GPULimitBuilder(GPULimit instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  GPULimitFluent<?> fluent;
  
  public GPULimit build() {
    GPULimit buildable = new GPULimit(fluent.getMax(),fluent.getMin(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}