/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.clusterautoscaling.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.clusterautoscaling.v1.ResourceLimits;
import io.fabric8.openshift.api.model.clusterautoscaling.v1.ResourceLimitsFluent;
import io.fabric8.openshift.api.model.clusterautoscaling.v1.ResourceLimitsFluentImpl;

public class ResourceLimitsBuilder
extends ResourceLimitsFluentImpl<ResourceLimitsBuilder>
implements VisitableBuilder<ResourceLimits, ResourceLimitsBuilder> {
    ResourceLimitsFluent<?> fluent;
    Boolean validationEnabled;

    public ResourceLimitsBuilder() {
        this(false);
    }

    public ResourceLimitsBuilder(Boolean validationEnabled) {
        this(new ResourceLimits(), validationEnabled);
    }

    public ResourceLimitsBuilder(ResourceLimitsFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public ResourceLimitsBuilder(ResourceLimitsFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ResourceLimits(), validationEnabled);
    }

    public ResourceLimitsBuilder(ResourceLimitsFluent<?> fluent, ResourceLimits instance) {
        this(fluent, instance, false);
    }

    public ResourceLimitsBuilder(ResourceLimitsFluent<?> fluent, ResourceLimits instance, Boolean validationEnabled) {
        this.fluent = fluent;
        if (instance != null) {
            fluent.withCores(instance.getCores());
            fluent.withGpus(instance.getGpus());
            fluent.withMaxNodesTotal(instance.getMaxNodesTotal());
            fluent.withMemory(instance.getMemory());
            fluent.withAdditionalProperties(instance.getAdditionalProperties());
        }
        this.validationEnabled = validationEnabled;
    }

    public ResourceLimitsBuilder(ResourceLimits instance) {
        this(instance, (Boolean)false);
    }

    public ResourceLimitsBuilder(ResourceLimits instance, Boolean validationEnabled) {
        this.fluent = this;
        if (instance != null) {
            this.withCores(instance.getCores());
            this.withGpus(instance.getGpus());
            this.withMaxNodesTotal(instance.getMaxNodesTotal());
            this.withMemory(instance.getMemory());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
        this.validationEnabled = validationEnabled;
    }

    public ResourceLimits build() {
        ResourceLimits buildable = new ResourceLimits(this.fluent.getCores(), this.fluent.getGpus(), this.fluent.getMaxNodesTotal(), this.fluent.getMemory());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }
}

