package io.fabric8.openshift.api.model.clusterautoscaling.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ResourceLimitsFluent<A extends ResourceLimitsFluent<A>> extends BaseFluent<A>{
  public ResourceLimitsFluent() {
  }
  
  public ResourceLimitsFluent(ResourceLimits instance) {
    this.copyInstance(instance);
  }
  private ResourceRangeBuilder cores;
  private ArrayList<GPULimitBuilder> gpus = new ArrayList<GPULimitBuilder>();
  private Integer maxNodesTotal;
  private ResourceRangeBuilder memory;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ResourceLimits instance) {
    instance = (instance != null ? instance : new ResourceLimits());
    if (instance != null) {
          this.withCores(instance.getCores());
          this.withGpus(instance.getGpus());
          this.withMaxNodesTotal(instance.getMaxNodesTotal());
          this.withMemory(instance.getMemory());
          this.withCores(instance.getCores());
          this.withGpus(instance.getGpus());
          this.withMaxNodesTotal(instance.getMaxNodesTotal());
          this.withMemory(instance.getMemory());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public ResourceRange buildCores() {
    return this.cores != null ? this.cores.build() : null;
  }
  
  public A withCores(ResourceRange cores) {
    this._visitables.remove(this.cores);
    if (cores != null) {
        this.cores = new ResourceRangeBuilder(cores);
        this._visitables.get("cores").add(this.cores);
    } else {
        this.cores = null;
        this._visitables.get("cores").remove(this.cores);
    }
    return (A) this;
  }
  
  public boolean hasCores() {
    return this.cores != null;
  }
  
  public A withNewCores(Integer max,Integer min) {
    return (A)withCores(new ResourceRange(max, min));
  }
  
  public CoresNested<A> withNewCores() {
    return new CoresNested(null);
  }
  
  public CoresNested<A> withNewCoresLike(ResourceRange item) {
    return new CoresNested(item);
  }
  
  public CoresNested<A> editCores() {
    return withNewCoresLike(java.util.Optional.ofNullable(buildCores()).orElse(null));
  }
  
  public CoresNested<A> editOrNewCores() {
    return withNewCoresLike(java.util.Optional.ofNullable(buildCores()).orElse(new ResourceRangeBuilder().build()));
  }
  
  public CoresNested<A> editOrNewCoresLike(ResourceRange item) {
    return withNewCoresLike(java.util.Optional.ofNullable(buildCores()).orElse(item));
  }
  
  public A addToGpus(int index,GPULimit item) {
    if (this.gpus == null) {this.gpus = new ArrayList<GPULimitBuilder>();}
    GPULimitBuilder builder = new GPULimitBuilder(item);
    if (index < 0 || index >= gpus.size()) { _visitables.get("gpus").add(builder); gpus.add(builder); } else { _visitables.get("gpus").add(index, builder); gpus.add(index, builder);}
    return (A)this;
  }
  
  public A setToGpus(int index,GPULimit item) {
    if (this.gpus == null) {this.gpus = new ArrayList<GPULimitBuilder>();}
    GPULimitBuilder builder = new GPULimitBuilder(item);
    if (index < 0 || index >= gpus.size()) { _visitables.get("gpus").add(builder); gpus.add(builder); } else { _visitables.get("gpus").set(index, builder); gpus.set(index, builder);}
    return (A)this;
  }
  
  public A addToGpus(io.fabric8.openshift.api.model.clusterautoscaling.v1.GPULimit... items) {
    if (this.gpus == null) {this.gpus = new ArrayList<GPULimitBuilder>();}
    for (GPULimit item : items) {GPULimitBuilder builder = new GPULimitBuilder(item);_visitables.get("gpus").add(builder);this.gpus.add(builder);} return (A)this;
  }
  
  public A addAllToGpus(Collection<GPULimit> items) {
    if (this.gpus == null) {this.gpus = new ArrayList<GPULimitBuilder>();}
    for (GPULimit item : items) {GPULimitBuilder builder = new GPULimitBuilder(item);_visitables.get("gpus").add(builder);this.gpus.add(builder);} return (A)this;
  }
  
  public A removeFromGpus(io.fabric8.openshift.api.model.clusterautoscaling.v1.GPULimit... items) {
    if (this.gpus == null) return (A)this;
    for (GPULimit item : items) {GPULimitBuilder builder = new GPULimitBuilder(item);_visitables.get("gpus").remove(builder); this.gpus.remove(builder);} return (A)this;
  }
  
  public A removeAllFromGpus(Collection<GPULimit> items) {
    if (this.gpus == null) return (A)this;
    for (GPULimit item : items) {GPULimitBuilder builder = new GPULimitBuilder(item);_visitables.get("gpus").remove(builder); this.gpus.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromGpus(Predicate<GPULimitBuilder> predicate) {
    if (gpus == null) return (A) this;
    final Iterator<GPULimitBuilder> each = gpus.iterator();
    final List visitables = _visitables.get("gpus");
    while (each.hasNext()) {
      GPULimitBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<GPULimit> buildGpus() {
    return this.gpus != null ? build(gpus) : null;
  }
  
  public GPULimit buildGpus(int index) {
    return this.gpus.get(index).build();
  }
  
  public GPULimit buildFirstGpus() {
    return this.gpus.get(0).build();
  }
  
  public GPULimit buildLastGpus() {
    return this.gpus.get(gpus.size() - 1).build();
  }
  
  public GPULimit buildMatchingGpus(Predicate<GPULimitBuilder> predicate) {
      for (GPULimitBuilder item : gpus) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingGpus(Predicate<GPULimitBuilder> predicate) {
      for (GPULimitBuilder item : gpus) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withGpus(List<GPULimit> gpus) {
    if (this.gpus != null) {
      this._visitables.get("gpus").clear();
    }
    if (gpus != null) {
        this.gpus = new ArrayList();
        for (GPULimit item : gpus) {
          this.addToGpus(item);
        }
    } else {
      this.gpus = null;
    }
    return (A) this;
  }
  
  public A withGpus(io.fabric8.openshift.api.model.clusterautoscaling.v1.GPULimit... gpus) {
    if (this.gpus != null) {this.gpus.clear(); _visitables.remove("gpus"); }
    if (gpus != null) {for (GPULimit item :gpus){ this.addToGpus(item);}} return (A) this;
  }
  
  public boolean hasGpus() {
    return this.gpus != null && !this.gpus.isEmpty();
  }
  
  public A addNewGpus(Integer max,Integer min,String type) {
    return (A)addToGpus(new GPULimit(max, min, type));
  }
  
  public GpusNested<A> addNewGpus() {
    return new GpusNested(-1, null);
  }
  
  public GpusNested<A> addNewGpusLike(GPULimit item) {
    return new GpusNested(-1, item);
  }
  
  public GpusNested<A> setNewGpusLike(int index,GPULimit item) {
    return new GpusNested(index, item);
  }
  
  public GpusNested<A> editGpus(int index) {
    if (gpus.size() <= index) throw new RuntimeException("Can't edit gpus. Index exceeds size.");
    return setNewGpusLike(index, buildGpus(index));
  }
  
  public GpusNested<A> editFirstGpus() {
    if (gpus.size() == 0) throw new RuntimeException("Can't edit first gpus. The list is empty.");
    return setNewGpusLike(0, buildGpus(0));
  }
  
  public GpusNested<A> editLastGpus() {
    int index = gpus.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last gpus. The list is empty.");
    return setNewGpusLike(index, buildGpus(index));
  }
  
  public GpusNested<A> editMatchingGpus(Predicate<GPULimitBuilder> predicate) {
    int index = -1;
    for (int i=0;i<gpus.size();i++) { 
    if (predicate.test(gpus.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching gpus. No match found.");
    return setNewGpusLike(index, buildGpus(index));
  }
  
  public Integer getMaxNodesTotal() {
    return this.maxNodesTotal;
  }
  
  public A withMaxNodesTotal(Integer maxNodesTotal) {
    this.maxNodesTotal = maxNodesTotal;
    return (A) this;
  }
  
  public boolean hasMaxNodesTotal() {
    return this.maxNodesTotal != null;
  }
  
  public ResourceRange buildMemory() {
    return this.memory != null ? this.memory.build() : null;
  }
  
  public A withMemory(ResourceRange memory) {
    this._visitables.remove(this.memory);
    if (memory != null) {
        this.memory = new ResourceRangeBuilder(memory);
        this._visitables.get("memory").add(this.memory);
    } else {
        this.memory = null;
        this._visitables.get("memory").remove(this.memory);
    }
    return (A) this;
  }
  
  public boolean hasMemory() {
    return this.memory != null;
  }
  
  public A withNewMemory(Integer max,Integer min) {
    return (A)withMemory(new ResourceRange(max, min));
  }
  
  public MemoryNested<A> withNewMemory() {
    return new MemoryNested(null);
  }
  
  public MemoryNested<A> withNewMemoryLike(ResourceRange item) {
    return new MemoryNested(item);
  }
  
  public MemoryNested<A> editMemory() {
    return withNewMemoryLike(java.util.Optional.ofNullable(buildMemory()).orElse(null));
  }
  
  public MemoryNested<A> editOrNewMemory() {
    return withNewMemoryLike(java.util.Optional.ofNullable(buildMemory()).orElse(new ResourceRangeBuilder().build()));
  }
  
  public MemoryNested<A> editOrNewMemoryLike(ResourceRange item) {
    return withNewMemoryLike(java.util.Optional.ofNullable(buildMemory()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ResourceLimitsFluent that = (ResourceLimitsFluent) o;
    if (!java.util.Objects.equals(cores, that.cores)) return false;
    if (!java.util.Objects.equals(gpus, that.gpus)) return false;
    if (!java.util.Objects.equals(maxNodesTotal, that.maxNodesTotal)) return false;
    if (!java.util.Objects.equals(memory, that.memory)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(cores,  gpus,  maxNodesTotal,  memory,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (cores != null) { sb.append("cores:"); sb.append(cores + ","); }
    if (gpus != null && !gpus.isEmpty()) { sb.append("gpus:"); sb.append(gpus + ","); }
    if (maxNodesTotal != null) { sb.append("maxNodesTotal:"); sb.append(maxNodesTotal + ","); }
    if (memory != null) { sb.append("memory:"); sb.append(memory + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class CoresNested<N> extends ResourceRangeFluent<CoresNested<N>> implements Nested<N>{
    CoresNested(ResourceRange item) {
      this.builder = new ResourceRangeBuilder(this, item);
    }
    ResourceRangeBuilder builder;
    
    public N and() {
      return (N) ResourceLimitsFluent.this.withCores(builder.build());
    }
    
    public N endCores() {
      return and();
    }
    
  
  }
  public class GpusNested<N> extends GPULimitFluent<GpusNested<N>> implements Nested<N>{
    GpusNested(int index,GPULimit item) {
      this.index = index;
      this.builder = new GPULimitBuilder(this, item);
    }
    GPULimitBuilder builder;
    int index;
    
    public N and() {
      return (N) ResourceLimitsFluent.this.setToGpus(index,builder.build());
    }
    
    public N endGpus() {
      return and();
    }
    
  
  }
  public class MemoryNested<N> extends ResourceRangeFluent<MemoryNested<N>> implements Nested<N>{
    MemoryNested(ResourceRange item) {
      this.builder = new ResourceRangeBuilder(this, item);
    }
    ResourceRangeBuilder builder;
    
    public N and() {
      return (N) ResourceLimitsFluent.this.withMemory(builder.build());
    }
    
    public N endMemory() {
      return and();
    }
    
  
  }

}