package io.fabric8.openshift.api.model.config.v1;

import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.HasMetadata;
import java.lang.Object;
import java.util.Map;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.util.List;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluentImpl;
import java.util.Collection;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.Iterator;
import java.lang.Integer;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ClusterOperatorStatusFluentImpl<A extends ClusterOperatorStatusFluent<A>> extends BaseFluent<A> implements ClusterOperatorStatusFluent<A>{
  public ClusterOperatorStatusFluentImpl() {
  }
  public ClusterOperatorStatusFluentImpl(ClusterOperatorStatus instance) {
    this.withConditions(instance.getConditions()); 
    this.withExtension(instance.getExtension()); 
    this.withRelatedObjects(instance.getRelatedObjects()); 
    this.withVersions(instance.getVersions()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private ArrayList<ClusterOperatorStatusConditionBuilder> conditions = new ArrayList<ClusterOperatorStatusConditionBuilder>();
  private VisitableBuilder<? extends HasMetadata,?> extension;
  private ArrayList<ObjectReferenceBuilder> relatedObjects = new ArrayList<ObjectReferenceBuilder>();
  private ArrayList<OperandVersionBuilder> versions = new ArrayList<OperandVersionBuilder>();
  private Map<String,Object> additionalProperties;
  public A addToConditions(Integer index,ClusterOperatorStatusCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<ClusterOperatorStatusConditionBuilder>();}
    ClusterOperatorStatusConditionBuilder builder = new ClusterOperatorStatusConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
  }
  public A setToConditions(Integer index,ClusterOperatorStatusCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<ClusterOperatorStatusConditionBuilder>();}
    ClusterOperatorStatusConditionBuilder builder = new ClusterOperatorStatusConditionBuilder(item);
    if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
    if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
     return (A)this;
  }
  public A addToConditions(io.fabric8.openshift.api.model.config.v1.ClusterOperatorStatusCondition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<ClusterOperatorStatusConditionBuilder>();}
    for (ClusterOperatorStatusCondition item : items) {ClusterOperatorStatusConditionBuilder builder = new ClusterOperatorStatusConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A addAllToConditions(Collection<ClusterOperatorStatusCondition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<ClusterOperatorStatusConditionBuilder>();}
    for (ClusterOperatorStatusCondition item : items) {ClusterOperatorStatusConditionBuilder builder = new ClusterOperatorStatusConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A removeFromConditions(io.fabric8.openshift.api.model.config.v1.ClusterOperatorStatusCondition... items) {
    for (ClusterOperatorStatusCondition item : items) {ClusterOperatorStatusConditionBuilder builder = new ClusterOperatorStatusConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeAllFromConditions(Collection<ClusterOperatorStatusCondition> items) {
    for (ClusterOperatorStatusCondition item : items) {ClusterOperatorStatusConditionBuilder builder = new ClusterOperatorStatusConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromConditions(Predicate<ClusterOperatorStatusConditionBuilder> predicate) {
    if (conditions == null) return (A) this;
    final Iterator<ClusterOperatorStatusConditionBuilder> each = conditions.iterator();
    final List visitables = _visitables.get("conditions");
    while (each.hasNext()) {
      ClusterOperatorStatusConditionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildConditions instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ClusterOperatorStatusCondition> getConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public List<ClusterOperatorStatusCondition> buildConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public ClusterOperatorStatusCondition buildCondition(Integer index) {
    return this.conditions.get(index).build();
  }
  public ClusterOperatorStatusCondition buildFirstCondition() {
    return this.conditions.get(0).build();
  }
  public ClusterOperatorStatusCondition buildLastCondition() {
    return this.conditions.get(conditions.size() - 1).build();
  }
  public ClusterOperatorStatusCondition buildMatchingCondition(Predicate<ClusterOperatorStatusConditionBuilder> predicate) {
    for (ClusterOperatorStatusConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingCondition(Predicate<ClusterOperatorStatusConditionBuilder> predicate) {
    for (ClusterOperatorStatusConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConditions(List<ClusterOperatorStatusCondition> conditions) {
    if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
    if (conditions != null) {this.conditions = new ArrayList(); for (ClusterOperatorStatusCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  public A withConditions(io.fabric8.openshift.api.model.config.v1.ClusterOperatorStatusCondition... conditions) {
    if (this.conditions != null) {this.conditions.clear();}
    if (conditions != null) {for (ClusterOperatorStatusCondition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  public Boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  public A addNewCondition(String lastTransitionTime,String message,String reason,String status,String type) {
    return (A)addToConditions(new ClusterOperatorStatusCondition(lastTransitionTime, message, reason, status, type));
  }
  public ClusterOperatorStatusFluent.ConditionsNested<A> addNewCondition() {
    return new ClusterOperatorStatusFluentImpl.ConditionsNestedImpl();
  }
  public ClusterOperatorStatusFluent.ConditionsNested<A> addNewConditionLike(ClusterOperatorStatusCondition item) {
    return new ClusterOperatorStatusFluentImpl.ConditionsNestedImpl(-1, item);
  }
  public ClusterOperatorStatusFluent.ConditionsNested<A> setNewConditionLike(Integer index,ClusterOperatorStatusCondition item) {
    return new ClusterOperatorStatusFluentImpl.ConditionsNestedImpl(index, item);
  }
  public ClusterOperatorStatusFluent.ConditionsNested<A> editCondition(Integer index) {
    if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public ClusterOperatorStatusFluent.ConditionsNested<A> editFirstCondition() {
    if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
    return setNewConditionLike(0, buildCondition(0));
  }
  public ClusterOperatorStatusFluent.ConditionsNested<A> editLastCondition() {
    int index = conditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public ClusterOperatorStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<ClusterOperatorStatusConditionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<conditions.size();i++) { 
    if (predicate.test(conditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
    return setNewConditionLike(index, buildCondition(index));
  }
  
  /**
   * This method has been deprecated, please use method buildExtension instead.
   * @return The buildable object.
   */
  @Deprecated
  public HasMetadata getExtension() {
    return this.extension!=null?this.extension.build():null;
  }
  public HasMetadata buildExtension() {
    return this.extension!=null?this.extension.build():null;
  }
  public A withExtension(HasMetadata extension) {
    if (extension instanceof Build){ this.extension= new BuildBuilder((Build)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof Project){ this.extension= new ProjectBuilder((Project)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof ClusterVersion){ this.extension= new ClusterVersionBuilder((ClusterVersion)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof ImageContentPolicy){ this.extension= new ImageContentPolicyBuilder((ImageContentPolicy)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof APIServer){ this.extension= new APIServerBuilder((APIServer)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof PersistentVolumeClaim){ this.extension= new PersistentVolumeClaimBuilder((PersistentVolumeClaim)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof Ingress){ this.extension= new IngressBuilder((Ingress)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof Authentication){ this.extension= new AuthenticationBuilder((Authentication)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof Image){ this.extension= new ImageBuilder((Image)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof DNS){ this.extension= new DNSBuilder((DNS)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof Network){ this.extension= new NetworkBuilder((Network)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof Console){ this.extension= new ConsoleBuilder((Console)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof Scheduler){ this.extension= new SchedulerBuilder((Scheduler)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof FeatureGate){ this.extension= new FeatureGateBuilder((FeatureGate)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof OperatorHub){ this.extension= new OperatorHubBuilder((OperatorHub)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof OAuth){ this.extension= new OAuthBuilder((OAuth)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof ClusterOperator){ this.extension= new ClusterOperatorBuilder((ClusterOperator)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof Infrastructure){ this.extension= new InfrastructureBuilder((Infrastructure)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof Proxy){ this.extension= new ProxyBuilder((Proxy)extension); _visitables.get("extension").add(this.extension);}
    return (A) this;
  }
  public Boolean hasExtension() {
    return this.extension != null;
  }
  public A withBuildExtension(Build buildExtension) {
    _visitables.get("extension").remove(this.extension);
    if (buildExtension!=null){ this.extension= new BuildBuilder(buildExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public ClusterOperatorStatusFluent.BuildExtensionNested<A> withNewBuildExtension() {
    return new ClusterOperatorStatusFluentImpl.BuildExtensionNestedImpl();
  }
  public ClusterOperatorStatusFluent.BuildExtensionNested<A> withNewBuildExtensionLike(Build item) {
    return new ClusterOperatorStatusFluentImpl.BuildExtensionNestedImpl(item);
  }
  public A withProjectExtension(Project projectExtension) {
    _visitables.get("extension").remove(this.extension);
    if (projectExtension!=null){ this.extension= new ProjectBuilder(projectExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public ClusterOperatorStatusFluent.ProjectExtensionNested<A> withNewProjectExtension() {
    return new ClusterOperatorStatusFluentImpl.ProjectExtensionNestedImpl();
  }
  public ClusterOperatorStatusFluent.ProjectExtensionNested<A> withNewProjectExtensionLike(Project item) {
    return new ClusterOperatorStatusFluentImpl.ProjectExtensionNestedImpl(item);
  }
  public A withClusterVersionExtension(ClusterVersion clusterVersionExtension) {
    _visitables.get("extension").remove(this.extension);
    if (clusterVersionExtension!=null){ this.extension= new ClusterVersionBuilder(clusterVersionExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public ClusterOperatorStatusFluent.ClusterVersionExtensionNested<A> withNewClusterVersionExtension() {
    return new ClusterOperatorStatusFluentImpl.ClusterVersionExtensionNestedImpl();
  }
  public ClusterOperatorStatusFluent.ClusterVersionExtensionNested<A> withNewClusterVersionExtensionLike(ClusterVersion item) {
    return new ClusterOperatorStatusFluentImpl.ClusterVersionExtensionNestedImpl(item);
  }
  public A withImageContentPolicyExtension(ImageContentPolicy imageContentPolicyExtension) {
    _visitables.get("extension").remove(this.extension);
    if (imageContentPolicyExtension!=null){ this.extension= new ImageContentPolicyBuilder(imageContentPolicyExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public ClusterOperatorStatusFluent.ImageContentPolicyExtensionNested<A> withNewImageContentPolicyExtension() {
    return new ClusterOperatorStatusFluentImpl.ImageContentPolicyExtensionNestedImpl();
  }
  public ClusterOperatorStatusFluent.ImageContentPolicyExtensionNested<A> withNewImageContentPolicyExtensionLike(ImageContentPolicy item) {
    return new ClusterOperatorStatusFluentImpl.ImageContentPolicyExtensionNestedImpl(item);
  }
  public A withAPIServerExtension(APIServer aPIServerExtension) {
    _visitables.get("extension").remove(this.extension);
    if (aPIServerExtension!=null){ this.extension= new APIServerBuilder(aPIServerExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public ClusterOperatorStatusFluent.APIServerExtensionNested<A> withNewAPIServerExtension() {
    return new ClusterOperatorStatusFluentImpl.APIServerExtensionNestedImpl();
  }
  public ClusterOperatorStatusFluent.APIServerExtensionNested<A> withNewAPIServerExtensionLike(APIServer item) {
    return new ClusterOperatorStatusFluentImpl.APIServerExtensionNestedImpl(item);
  }
  public A withPersistentVolumeClaimExtension(PersistentVolumeClaim persistentVolumeClaimExtension) {
    _visitables.get("extension").remove(this.extension);
    if (persistentVolumeClaimExtension!=null){ this.extension= new PersistentVolumeClaimBuilder(persistentVolumeClaimExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public ClusterOperatorStatusFluent.PersistentVolumeClaimExtensionNested<A> withNewPersistentVolumeClaimExtension() {
    return new ClusterOperatorStatusFluentImpl.PersistentVolumeClaimExtensionNestedImpl();
  }
  public ClusterOperatorStatusFluent.PersistentVolumeClaimExtensionNested<A> withNewPersistentVolumeClaimExtensionLike(PersistentVolumeClaim item) {
    return new ClusterOperatorStatusFluentImpl.PersistentVolumeClaimExtensionNestedImpl(item);
  }
  public A withIngressExtension(Ingress ingressExtension) {
    _visitables.get("extension").remove(this.extension);
    if (ingressExtension!=null){ this.extension= new IngressBuilder(ingressExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public ClusterOperatorStatusFluent.IngressExtensionNested<A> withNewIngressExtension() {
    return new ClusterOperatorStatusFluentImpl.IngressExtensionNestedImpl();
  }
  public ClusterOperatorStatusFluent.IngressExtensionNested<A> withNewIngressExtensionLike(Ingress item) {
    return new ClusterOperatorStatusFluentImpl.IngressExtensionNestedImpl(item);
  }
  public A withAuthenticationExtension(Authentication authenticationExtension) {
    _visitables.get("extension").remove(this.extension);
    if (authenticationExtension!=null){ this.extension= new AuthenticationBuilder(authenticationExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public ClusterOperatorStatusFluent.AuthenticationExtensionNested<A> withNewAuthenticationExtension() {
    return new ClusterOperatorStatusFluentImpl.AuthenticationExtensionNestedImpl();
  }
  public ClusterOperatorStatusFluent.AuthenticationExtensionNested<A> withNewAuthenticationExtensionLike(Authentication item) {
    return new ClusterOperatorStatusFluentImpl.AuthenticationExtensionNestedImpl(item);
  }
  public A withImageExtension(Image imageExtension) {
    _visitables.get("extension").remove(this.extension);
    if (imageExtension!=null){ this.extension= new ImageBuilder(imageExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public ClusterOperatorStatusFluent.ImageExtensionNested<A> withNewImageExtension() {
    return new ClusterOperatorStatusFluentImpl.ImageExtensionNestedImpl();
  }
  public ClusterOperatorStatusFluent.ImageExtensionNested<A> withNewImageExtensionLike(Image item) {
    return new ClusterOperatorStatusFluentImpl.ImageExtensionNestedImpl(item);
  }
  public A withDNSExtension(DNS dNSExtension) {
    _visitables.get("extension").remove(this.extension);
    if (dNSExtension!=null){ this.extension= new DNSBuilder(dNSExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public ClusterOperatorStatusFluent.DNSExtensionNested<A> withNewDNSExtension() {
    return new ClusterOperatorStatusFluentImpl.DNSExtensionNestedImpl();
  }
  public ClusterOperatorStatusFluent.DNSExtensionNested<A> withNewDNSExtensionLike(DNS item) {
    return new ClusterOperatorStatusFluentImpl.DNSExtensionNestedImpl(item);
  }
  public A withNetworkExtension(Network networkExtension) {
    _visitables.get("extension").remove(this.extension);
    if (networkExtension!=null){ this.extension= new NetworkBuilder(networkExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public ClusterOperatorStatusFluent.NetworkExtensionNested<A> withNewNetworkExtension() {
    return new ClusterOperatorStatusFluentImpl.NetworkExtensionNestedImpl();
  }
  public ClusterOperatorStatusFluent.NetworkExtensionNested<A> withNewNetworkExtensionLike(Network item) {
    return new ClusterOperatorStatusFluentImpl.NetworkExtensionNestedImpl(item);
  }
  public A withConsoleExtension(Console consoleExtension) {
    _visitables.get("extension").remove(this.extension);
    if (consoleExtension!=null){ this.extension= new ConsoleBuilder(consoleExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public ClusterOperatorStatusFluent.ConsoleExtensionNested<A> withNewConsoleExtension() {
    return new ClusterOperatorStatusFluentImpl.ConsoleExtensionNestedImpl();
  }
  public ClusterOperatorStatusFluent.ConsoleExtensionNested<A> withNewConsoleExtensionLike(Console item) {
    return new ClusterOperatorStatusFluentImpl.ConsoleExtensionNestedImpl(item);
  }
  public A withSchedulerExtension(Scheduler schedulerExtension) {
    _visitables.get("extension").remove(this.extension);
    if (schedulerExtension!=null){ this.extension= new SchedulerBuilder(schedulerExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public ClusterOperatorStatusFluent.SchedulerExtensionNested<A> withNewSchedulerExtension() {
    return new ClusterOperatorStatusFluentImpl.SchedulerExtensionNestedImpl();
  }
  public ClusterOperatorStatusFluent.SchedulerExtensionNested<A> withNewSchedulerExtensionLike(Scheduler item) {
    return new ClusterOperatorStatusFluentImpl.SchedulerExtensionNestedImpl(item);
  }
  public A withFeatureGateExtension(FeatureGate featureGateExtension) {
    _visitables.get("extension").remove(this.extension);
    if (featureGateExtension!=null){ this.extension= new FeatureGateBuilder(featureGateExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public ClusterOperatorStatusFluent.FeatureGateExtensionNested<A> withNewFeatureGateExtension() {
    return new ClusterOperatorStatusFluentImpl.FeatureGateExtensionNestedImpl();
  }
  public ClusterOperatorStatusFluent.FeatureGateExtensionNested<A> withNewFeatureGateExtensionLike(FeatureGate item) {
    return new ClusterOperatorStatusFluentImpl.FeatureGateExtensionNestedImpl(item);
  }
  public A withOperatorHubExtension(OperatorHub operatorHubExtension) {
    _visitables.get("extension").remove(this.extension);
    if (operatorHubExtension!=null){ this.extension= new OperatorHubBuilder(operatorHubExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public ClusterOperatorStatusFluent.OperatorHubExtensionNested<A> withNewOperatorHubExtension() {
    return new ClusterOperatorStatusFluentImpl.OperatorHubExtensionNestedImpl();
  }
  public ClusterOperatorStatusFluent.OperatorHubExtensionNested<A> withNewOperatorHubExtensionLike(OperatorHub item) {
    return new ClusterOperatorStatusFluentImpl.OperatorHubExtensionNestedImpl(item);
  }
  public A withOAuthExtension(OAuth oAuthExtension) {
    _visitables.get("extension").remove(this.extension);
    if (oAuthExtension!=null){ this.extension= new OAuthBuilder(oAuthExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public ClusterOperatorStatusFluent.OAuthExtensionNested<A> withNewOAuthExtension() {
    return new ClusterOperatorStatusFluentImpl.OAuthExtensionNestedImpl();
  }
  public ClusterOperatorStatusFluent.OAuthExtensionNested<A> withNewOAuthExtensionLike(OAuth item) {
    return new ClusterOperatorStatusFluentImpl.OAuthExtensionNestedImpl(item);
  }
  public A withClusterOperatorExtension(ClusterOperator clusterOperatorExtension) {
    _visitables.get("extension").remove(this.extension);
    if (clusterOperatorExtension!=null){ this.extension= new ClusterOperatorBuilder(clusterOperatorExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public ClusterOperatorStatusFluent.ClusterOperatorExtensionNested<A> withNewClusterOperatorExtension() {
    return new ClusterOperatorStatusFluentImpl.ClusterOperatorExtensionNestedImpl();
  }
  public ClusterOperatorStatusFluent.ClusterOperatorExtensionNested<A> withNewClusterOperatorExtensionLike(ClusterOperator item) {
    return new ClusterOperatorStatusFluentImpl.ClusterOperatorExtensionNestedImpl(item);
  }
  public A withInfrastructureExtension(Infrastructure infrastructureExtension) {
    _visitables.get("extension").remove(this.extension);
    if (infrastructureExtension!=null){ this.extension= new InfrastructureBuilder(infrastructureExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public ClusterOperatorStatusFluent.InfrastructureExtensionNested<A> withNewInfrastructureExtension() {
    return new ClusterOperatorStatusFluentImpl.InfrastructureExtensionNestedImpl();
  }
  public ClusterOperatorStatusFluent.InfrastructureExtensionNested<A> withNewInfrastructureExtensionLike(Infrastructure item) {
    return new ClusterOperatorStatusFluentImpl.InfrastructureExtensionNestedImpl(item);
  }
  public A withProxyExtension(Proxy proxyExtension) {
    _visitables.get("extension").remove(this.extension);
    if (proxyExtension!=null){ this.extension= new ProxyBuilder(proxyExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public ClusterOperatorStatusFluent.ProxyExtensionNested<A> withNewProxyExtension() {
    return new ClusterOperatorStatusFluentImpl.ProxyExtensionNestedImpl();
  }
  public ClusterOperatorStatusFluent.ProxyExtensionNested<A> withNewProxyExtensionLike(Proxy item) {
    return new ClusterOperatorStatusFluentImpl.ProxyExtensionNestedImpl(item);
  }
  public A addToRelatedObjects(Integer index,ObjectReference item) {
    if (this.relatedObjects == null) {this.relatedObjects = new ArrayList<ObjectReferenceBuilder>();}
    ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);_visitables.get("relatedObjects").add(index >= 0 ? index : _visitables.get("relatedObjects").size(), builder);this.relatedObjects.add(index >= 0 ? index : relatedObjects.size(), builder); return (A)this;
  }
  public A setToRelatedObjects(Integer index,ObjectReference item) {
    if (this.relatedObjects == null) {this.relatedObjects = new ArrayList<ObjectReferenceBuilder>();}
    ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
    if (index < 0 || index >= _visitables.get("relatedObjects").size()) { _visitables.get("relatedObjects").add(builder); } else { _visitables.get("relatedObjects").set(index, builder);}
    if (index < 0 || index >= relatedObjects.size()) { relatedObjects.add(builder); } else { relatedObjects.set(index, builder);}
     return (A)this;
  }
  public A addToRelatedObjects(io.fabric8.openshift.api.model.config.v1.ObjectReference... items) {
    if (this.relatedObjects == null) {this.relatedObjects = new ArrayList<ObjectReferenceBuilder>();}
    for (ObjectReference item : items) {ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);_visitables.get("relatedObjects").add(builder);this.relatedObjects.add(builder);} return (A)this;
  }
  public A addAllToRelatedObjects(Collection<ObjectReference> items) {
    if (this.relatedObjects == null) {this.relatedObjects = new ArrayList<ObjectReferenceBuilder>();}
    for (ObjectReference item : items) {ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);_visitables.get("relatedObjects").add(builder);this.relatedObjects.add(builder);} return (A)this;
  }
  public A removeFromRelatedObjects(io.fabric8.openshift.api.model.config.v1.ObjectReference... items) {
    for (ObjectReference item : items) {ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);_visitables.get("relatedObjects").remove(builder);if (this.relatedObjects != null) {this.relatedObjects.remove(builder);}} return (A)this;
  }
  public A removeAllFromRelatedObjects(Collection<ObjectReference> items) {
    for (ObjectReference item : items) {ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);_visitables.get("relatedObjects").remove(builder);if (this.relatedObjects != null) {this.relatedObjects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromRelatedObjects(Predicate<ObjectReferenceBuilder> predicate) {
    if (relatedObjects == null) return (A) this;
    final Iterator<ObjectReferenceBuilder> each = relatedObjects.iterator();
    final List visitables = _visitables.get("relatedObjects");
    while (each.hasNext()) {
      ObjectReferenceBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildRelatedObjects instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ObjectReference> getRelatedObjects() {
    return relatedObjects != null ? build(relatedObjects) : null;
  }
  public List<ObjectReference> buildRelatedObjects() {
    return relatedObjects != null ? build(relatedObjects) : null;
  }
  public ObjectReference buildRelatedObject(Integer index) {
    return this.relatedObjects.get(index).build();
  }
  public ObjectReference buildFirstRelatedObject() {
    return this.relatedObjects.get(0).build();
  }
  public ObjectReference buildLastRelatedObject() {
    return this.relatedObjects.get(relatedObjects.size() - 1).build();
  }
  public ObjectReference buildMatchingRelatedObject(Predicate<ObjectReferenceBuilder> predicate) {
    for (ObjectReferenceBuilder item: relatedObjects) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingRelatedObject(Predicate<ObjectReferenceBuilder> predicate) {
    for (ObjectReferenceBuilder item: relatedObjects) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withRelatedObjects(List<ObjectReference> relatedObjects) {
    if (this.relatedObjects != null) { _visitables.get("relatedObjects").removeAll(this.relatedObjects);}
    if (relatedObjects != null) {this.relatedObjects = new ArrayList(); for (ObjectReference item : relatedObjects){this.addToRelatedObjects(item);}} else { this.relatedObjects = null;} return (A) this;
  }
  public A withRelatedObjects(io.fabric8.openshift.api.model.config.v1.ObjectReference... relatedObjects) {
    if (this.relatedObjects != null) {this.relatedObjects.clear();}
    if (relatedObjects != null) {for (ObjectReference item :relatedObjects){ this.addToRelatedObjects(item);}} return (A) this;
  }
  public Boolean hasRelatedObjects() {
    return relatedObjects != null && !relatedObjects.isEmpty();
  }
  public A addNewRelatedObject(String group,String name,String namespace,String resource) {
    return (A)addToRelatedObjects(new ObjectReference(group, name, namespace, resource));
  }
  public ClusterOperatorStatusFluent.RelatedObjectsNested<A> addNewRelatedObject() {
    return new ClusterOperatorStatusFluentImpl.RelatedObjectsNestedImpl();
  }
  public ClusterOperatorStatusFluent.RelatedObjectsNested<A> addNewRelatedObjectLike(ObjectReference item) {
    return new ClusterOperatorStatusFluentImpl.RelatedObjectsNestedImpl(-1, item);
  }
  public ClusterOperatorStatusFluent.RelatedObjectsNested<A> setNewRelatedObjectLike(Integer index,ObjectReference item) {
    return new ClusterOperatorStatusFluentImpl.RelatedObjectsNestedImpl(index, item);
  }
  public ClusterOperatorStatusFluent.RelatedObjectsNested<A> editRelatedObject(Integer index) {
    if (relatedObjects.size() <= index) throw new RuntimeException("Can't edit relatedObjects. Index exceeds size.");
    return setNewRelatedObjectLike(index, buildRelatedObject(index));
  }
  public ClusterOperatorStatusFluent.RelatedObjectsNested<A> editFirstRelatedObject() {
    if (relatedObjects.size() == 0) throw new RuntimeException("Can't edit first relatedObjects. The list is empty.");
    return setNewRelatedObjectLike(0, buildRelatedObject(0));
  }
  public ClusterOperatorStatusFluent.RelatedObjectsNested<A> editLastRelatedObject() {
    int index = relatedObjects.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last relatedObjects. The list is empty.");
    return setNewRelatedObjectLike(index, buildRelatedObject(index));
  }
  public ClusterOperatorStatusFluent.RelatedObjectsNested<A> editMatchingRelatedObject(Predicate<ObjectReferenceBuilder> predicate) {
    int index = -1;
    for (int i=0;i<relatedObjects.size();i++) { 
    if (predicate.test(relatedObjects.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching relatedObjects. No match found.");
    return setNewRelatedObjectLike(index, buildRelatedObject(index));
  }
  public A addToVersions(Integer index,OperandVersion item) {
    if (this.versions == null) {this.versions = new ArrayList<OperandVersionBuilder>();}
    OperandVersionBuilder builder = new OperandVersionBuilder(item);_visitables.get("versions").add(index >= 0 ? index : _visitables.get("versions").size(), builder);this.versions.add(index >= 0 ? index : versions.size(), builder); return (A)this;
  }
  public A setToVersions(Integer index,OperandVersion item) {
    if (this.versions == null) {this.versions = new ArrayList<OperandVersionBuilder>();}
    OperandVersionBuilder builder = new OperandVersionBuilder(item);
    if (index < 0 || index >= _visitables.get("versions").size()) { _visitables.get("versions").add(builder); } else { _visitables.get("versions").set(index, builder);}
    if (index < 0 || index >= versions.size()) { versions.add(builder); } else { versions.set(index, builder);}
     return (A)this;
  }
  public A addToVersions(io.fabric8.openshift.api.model.config.v1.OperandVersion... items) {
    if (this.versions == null) {this.versions = new ArrayList<OperandVersionBuilder>();}
    for (OperandVersion item : items) {OperandVersionBuilder builder = new OperandVersionBuilder(item);_visitables.get("versions").add(builder);this.versions.add(builder);} return (A)this;
  }
  public A addAllToVersions(Collection<OperandVersion> items) {
    if (this.versions == null) {this.versions = new ArrayList<OperandVersionBuilder>();}
    for (OperandVersion item : items) {OperandVersionBuilder builder = new OperandVersionBuilder(item);_visitables.get("versions").add(builder);this.versions.add(builder);} return (A)this;
  }
  public A removeFromVersions(io.fabric8.openshift.api.model.config.v1.OperandVersion... items) {
    for (OperandVersion item : items) {OperandVersionBuilder builder = new OperandVersionBuilder(item);_visitables.get("versions").remove(builder);if (this.versions != null) {this.versions.remove(builder);}} return (A)this;
  }
  public A removeAllFromVersions(Collection<OperandVersion> items) {
    for (OperandVersion item : items) {OperandVersionBuilder builder = new OperandVersionBuilder(item);_visitables.get("versions").remove(builder);if (this.versions != null) {this.versions.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromVersions(Predicate<OperandVersionBuilder> predicate) {
    if (versions == null) return (A) this;
    final Iterator<OperandVersionBuilder> each = versions.iterator();
    final List visitables = _visitables.get("versions");
    while (each.hasNext()) {
      OperandVersionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildVersions instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<OperandVersion> getVersions() {
    return versions != null ? build(versions) : null;
  }
  public List<OperandVersion> buildVersions() {
    return versions != null ? build(versions) : null;
  }
  public OperandVersion buildVersion(Integer index) {
    return this.versions.get(index).build();
  }
  public OperandVersion buildFirstVersion() {
    return this.versions.get(0).build();
  }
  public OperandVersion buildLastVersion() {
    return this.versions.get(versions.size() - 1).build();
  }
  public OperandVersion buildMatchingVersion(Predicate<OperandVersionBuilder> predicate) {
    for (OperandVersionBuilder item: versions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingVersion(Predicate<OperandVersionBuilder> predicate) {
    for (OperandVersionBuilder item: versions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withVersions(List<OperandVersion> versions) {
    if (this.versions != null) { _visitables.get("versions").removeAll(this.versions);}
    if (versions != null) {this.versions = new ArrayList(); for (OperandVersion item : versions){this.addToVersions(item);}} else { this.versions = null;} return (A) this;
  }
  public A withVersions(io.fabric8.openshift.api.model.config.v1.OperandVersion... versions) {
    if (this.versions != null) {this.versions.clear();}
    if (versions != null) {for (OperandVersion item :versions){ this.addToVersions(item);}} return (A) this;
  }
  public Boolean hasVersions() {
    return versions != null && !versions.isEmpty();
  }
  public A addNewVersion(String name,String version) {
    return (A)addToVersions(new OperandVersion(name, version));
  }
  public ClusterOperatorStatusFluent.VersionsNested<A> addNewVersion() {
    return new ClusterOperatorStatusFluentImpl.VersionsNestedImpl();
  }
  public ClusterOperatorStatusFluent.VersionsNested<A> addNewVersionLike(OperandVersion item) {
    return new ClusterOperatorStatusFluentImpl.VersionsNestedImpl(-1, item);
  }
  public ClusterOperatorStatusFluent.VersionsNested<A> setNewVersionLike(Integer index,OperandVersion item) {
    return new ClusterOperatorStatusFluentImpl.VersionsNestedImpl(index, item);
  }
  public ClusterOperatorStatusFluent.VersionsNested<A> editVersion(Integer index) {
    if (versions.size() <= index) throw new RuntimeException("Can't edit versions. Index exceeds size.");
    return setNewVersionLike(index, buildVersion(index));
  }
  public ClusterOperatorStatusFluent.VersionsNested<A> editFirstVersion() {
    if (versions.size() == 0) throw new RuntimeException("Can't edit first versions. The list is empty.");
    return setNewVersionLike(0, buildVersion(0));
  }
  public ClusterOperatorStatusFluent.VersionsNested<A> editLastVersion() {
    int index = versions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last versions. The list is empty.");
    return setNewVersionLike(index, buildVersion(index));
  }
  public ClusterOperatorStatusFluent.VersionsNested<A> editMatchingVersion(Predicate<OperandVersionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<versions.size();i++) { 
    if (predicate.test(versions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching versions. No match found.");
    return setNewVersionLike(index, buildVersion(index));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ClusterOperatorStatusFluentImpl that = (ClusterOperatorStatusFluentImpl) o;
    if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
    if (extension != null ? !extension.equals(that.extension) :that.extension != null) return false;
    if (relatedObjects != null ? !relatedObjects.equals(that.relatedObjects) :that.relatedObjects != null) return false;
    if (versions != null ? !versions.equals(that.versions) :that.versions != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(conditions,  extension,  relatedObjects,  versions,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (conditions != null && !conditions.isEmpty()) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (extension != null) { sb.append("extension:"); sb.append(extension + ","); }
    if (relatedObjects != null && !relatedObjects.isEmpty()) { sb.append("relatedObjects:"); sb.append(relatedObjects + ","); }
    if (versions != null && !versions.isEmpty()) { sb.append("versions:"); sb.append(versions + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class ConditionsNestedImpl<N> extends ClusterOperatorStatusConditionFluentImpl<ClusterOperatorStatusFluent.ConditionsNested<N>> implements ClusterOperatorStatusFluent.ConditionsNested<N>,Nested<N>{
    ConditionsNestedImpl(Integer index,ClusterOperatorStatusCondition item) {
      this.index = index;
      this.builder = new ClusterOperatorStatusConditionBuilder(this, item);
    }
    ConditionsNestedImpl() {
      this.index = -1;
      this.builder = new ClusterOperatorStatusConditionBuilder(this);
    }
    ClusterOperatorStatusConditionBuilder builder;
    Integer index;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.setToConditions(index,builder.build());
    }
    public N endCondition() {
      return and();
    }
    
  }
  class BuildExtensionNestedImpl<N> extends BuildFluentImpl<ClusterOperatorStatusFluent.BuildExtensionNested<N>> implements ClusterOperatorStatusFluent.BuildExtensionNested<N>,Nested<N>{
    BuildExtensionNestedImpl(Build item) {
      this.builder = new BuildBuilder(this, item);
    }
    BuildExtensionNestedImpl() {
      this.builder = new BuildBuilder(this);
    }
    BuildBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endBuildExtension() {
      return and();
    }
    
  }
  class ProjectExtensionNestedImpl<N> extends ProjectFluentImpl<ClusterOperatorStatusFluent.ProjectExtensionNested<N>> implements ClusterOperatorStatusFluent.ProjectExtensionNested<N>,Nested<N>{
    ProjectExtensionNestedImpl(Project item) {
      this.builder = new ProjectBuilder(this, item);
    }
    ProjectExtensionNestedImpl() {
      this.builder = new ProjectBuilder(this);
    }
    ProjectBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endProjectExtension() {
      return and();
    }
    
  }
  class ClusterVersionExtensionNestedImpl<N> extends ClusterVersionFluentImpl<ClusterOperatorStatusFluent.ClusterVersionExtensionNested<N>> implements ClusterOperatorStatusFluent.ClusterVersionExtensionNested<N>,Nested<N>{
    ClusterVersionExtensionNestedImpl(ClusterVersion item) {
      this.builder = new ClusterVersionBuilder(this, item);
    }
    ClusterVersionExtensionNestedImpl() {
      this.builder = new ClusterVersionBuilder(this);
    }
    ClusterVersionBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endClusterVersionExtension() {
      return and();
    }
    
  }
  class ImageContentPolicyExtensionNestedImpl<N> extends ImageContentPolicyFluentImpl<ClusterOperatorStatusFluent.ImageContentPolicyExtensionNested<N>> implements ClusterOperatorStatusFluent.ImageContentPolicyExtensionNested<N>,Nested<N>{
    ImageContentPolicyExtensionNestedImpl(ImageContentPolicy item) {
      this.builder = new ImageContentPolicyBuilder(this, item);
    }
    ImageContentPolicyExtensionNestedImpl() {
      this.builder = new ImageContentPolicyBuilder(this);
    }
    ImageContentPolicyBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endImageContentPolicyExtension() {
      return and();
    }
    
  }
  class APIServerExtensionNestedImpl<N> extends APIServerFluentImpl<ClusterOperatorStatusFluent.APIServerExtensionNested<N>> implements ClusterOperatorStatusFluent.APIServerExtensionNested<N>,Nested<N>{
    APIServerExtensionNestedImpl(APIServer item) {
      this.builder = new APIServerBuilder(this, item);
    }
    APIServerExtensionNestedImpl() {
      this.builder = new APIServerBuilder(this);
    }
    APIServerBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endAPIServerExtension() {
      return and();
    }
    
  }
  class PersistentVolumeClaimExtensionNestedImpl<N> extends PersistentVolumeClaimFluentImpl<ClusterOperatorStatusFluent.PersistentVolumeClaimExtensionNested<N>> implements ClusterOperatorStatusFluent.PersistentVolumeClaimExtensionNested<N>,Nested<N>{
    PersistentVolumeClaimExtensionNestedImpl(PersistentVolumeClaim item) {
      this.builder = new PersistentVolumeClaimBuilder(this, item);
    }
    PersistentVolumeClaimExtensionNestedImpl() {
      this.builder = new PersistentVolumeClaimBuilder(this);
    }
    PersistentVolumeClaimBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endPersistentVolumeClaimExtension() {
      return and();
    }
    
  }
  class IngressExtensionNestedImpl<N> extends IngressFluentImpl<ClusterOperatorStatusFluent.IngressExtensionNested<N>> implements ClusterOperatorStatusFluent.IngressExtensionNested<N>,Nested<N>{
    IngressExtensionNestedImpl(Ingress item) {
      this.builder = new IngressBuilder(this, item);
    }
    IngressExtensionNestedImpl() {
      this.builder = new IngressBuilder(this);
    }
    IngressBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endIngressExtension() {
      return and();
    }
    
  }
  class AuthenticationExtensionNestedImpl<N> extends AuthenticationFluentImpl<ClusterOperatorStatusFluent.AuthenticationExtensionNested<N>> implements ClusterOperatorStatusFluent.AuthenticationExtensionNested<N>,Nested<N>{
    AuthenticationExtensionNestedImpl(Authentication item) {
      this.builder = new AuthenticationBuilder(this, item);
    }
    AuthenticationExtensionNestedImpl() {
      this.builder = new AuthenticationBuilder(this);
    }
    AuthenticationBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endAuthenticationExtension() {
      return and();
    }
    
  }
  class ImageExtensionNestedImpl<N> extends ImageFluentImpl<ClusterOperatorStatusFluent.ImageExtensionNested<N>> implements ClusterOperatorStatusFluent.ImageExtensionNested<N>,Nested<N>{
    ImageExtensionNestedImpl(Image item) {
      this.builder = new ImageBuilder(this, item);
    }
    ImageExtensionNestedImpl() {
      this.builder = new ImageBuilder(this);
    }
    ImageBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endImageExtension() {
      return and();
    }
    
  }
  class DNSExtensionNestedImpl<N> extends DNSFluentImpl<ClusterOperatorStatusFluent.DNSExtensionNested<N>> implements ClusterOperatorStatusFluent.DNSExtensionNested<N>,Nested<N>{
    DNSExtensionNestedImpl(DNS item) {
      this.builder = new DNSBuilder(this, item);
    }
    DNSExtensionNestedImpl() {
      this.builder = new DNSBuilder(this);
    }
    DNSBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endDNSExtension() {
      return and();
    }
    
  }
  class NetworkExtensionNestedImpl<N> extends NetworkFluentImpl<ClusterOperatorStatusFluent.NetworkExtensionNested<N>> implements ClusterOperatorStatusFluent.NetworkExtensionNested<N>,Nested<N>{
    NetworkExtensionNestedImpl(Network item) {
      this.builder = new NetworkBuilder(this, item);
    }
    NetworkExtensionNestedImpl() {
      this.builder = new NetworkBuilder(this);
    }
    NetworkBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endNetworkExtension() {
      return and();
    }
    
  }
  class ConsoleExtensionNestedImpl<N> extends ConsoleFluentImpl<ClusterOperatorStatusFluent.ConsoleExtensionNested<N>> implements ClusterOperatorStatusFluent.ConsoleExtensionNested<N>,Nested<N>{
    ConsoleExtensionNestedImpl(Console item) {
      this.builder = new ConsoleBuilder(this, item);
    }
    ConsoleExtensionNestedImpl() {
      this.builder = new ConsoleBuilder(this);
    }
    ConsoleBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endConsoleExtension() {
      return and();
    }
    
  }
  class SchedulerExtensionNestedImpl<N> extends SchedulerFluentImpl<ClusterOperatorStatusFluent.SchedulerExtensionNested<N>> implements ClusterOperatorStatusFluent.SchedulerExtensionNested<N>,Nested<N>{
    SchedulerExtensionNestedImpl(Scheduler item) {
      this.builder = new SchedulerBuilder(this, item);
    }
    SchedulerExtensionNestedImpl() {
      this.builder = new SchedulerBuilder(this);
    }
    SchedulerBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endSchedulerExtension() {
      return and();
    }
    
  }
  class FeatureGateExtensionNestedImpl<N> extends FeatureGateFluentImpl<ClusterOperatorStatusFluent.FeatureGateExtensionNested<N>> implements ClusterOperatorStatusFluent.FeatureGateExtensionNested<N>,Nested<N>{
    FeatureGateExtensionNestedImpl(FeatureGate item) {
      this.builder = new FeatureGateBuilder(this, item);
    }
    FeatureGateExtensionNestedImpl() {
      this.builder = new FeatureGateBuilder(this);
    }
    FeatureGateBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endFeatureGateExtension() {
      return and();
    }
    
  }
  class OperatorHubExtensionNestedImpl<N> extends OperatorHubFluentImpl<ClusterOperatorStatusFluent.OperatorHubExtensionNested<N>> implements ClusterOperatorStatusFluent.OperatorHubExtensionNested<N>,Nested<N>{
    OperatorHubExtensionNestedImpl(OperatorHub item) {
      this.builder = new OperatorHubBuilder(this, item);
    }
    OperatorHubExtensionNestedImpl() {
      this.builder = new OperatorHubBuilder(this);
    }
    OperatorHubBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endOperatorHubExtension() {
      return and();
    }
    
  }
  class OAuthExtensionNestedImpl<N> extends OAuthFluentImpl<ClusterOperatorStatusFluent.OAuthExtensionNested<N>> implements ClusterOperatorStatusFluent.OAuthExtensionNested<N>,Nested<N>{
    OAuthExtensionNestedImpl(OAuth item) {
      this.builder = new OAuthBuilder(this, item);
    }
    OAuthExtensionNestedImpl() {
      this.builder = new OAuthBuilder(this);
    }
    OAuthBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endOAuthExtension() {
      return and();
    }
    
  }
  class ClusterOperatorExtensionNestedImpl<N> extends ClusterOperatorFluentImpl<ClusterOperatorStatusFluent.ClusterOperatorExtensionNested<N>> implements ClusterOperatorStatusFluent.ClusterOperatorExtensionNested<N>,Nested<N>{
    ClusterOperatorExtensionNestedImpl(ClusterOperator item) {
      this.builder = new ClusterOperatorBuilder(this, item);
    }
    ClusterOperatorExtensionNestedImpl() {
      this.builder = new ClusterOperatorBuilder(this);
    }
    ClusterOperatorBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endClusterOperatorExtension() {
      return and();
    }
    
  }
  class InfrastructureExtensionNestedImpl<N> extends InfrastructureFluentImpl<ClusterOperatorStatusFluent.InfrastructureExtensionNested<N>> implements ClusterOperatorStatusFluent.InfrastructureExtensionNested<N>,Nested<N>{
    InfrastructureExtensionNestedImpl(Infrastructure item) {
      this.builder = new InfrastructureBuilder(this, item);
    }
    InfrastructureExtensionNestedImpl() {
      this.builder = new InfrastructureBuilder(this);
    }
    InfrastructureBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endInfrastructureExtension() {
      return and();
    }
    
  }
  class ProxyExtensionNestedImpl<N> extends ProxyFluentImpl<ClusterOperatorStatusFluent.ProxyExtensionNested<N>> implements ClusterOperatorStatusFluent.ProxyExtensionNested<N>,Nested<N>{
    ProxyExtensionNestedImpl(Proxy item) {
      this.builder = new ProxyBuilder(this, item);
    }
    ProxyExtensionNestedImpl() {
      this.builder = new ProxyBuilder(this);
    }
    ProxyBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endProxyExtension() {
      return and();
    }
    
  }
  class RelatedObjectsNestedImpl<N> extends ObjectReferenceFluentImpl<ClusterOperatorStatusFluent.RelatedObjectsNested<N>> implements ClusterOperatorStatusFluent.RelatedObjectsNested<N>,Nested<N>{
    RelatedObjectsNestedImpl(Integer index,ObjectReference item) {
      this.index = index;
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    RelatedObjectsNestedImpl() {
      this.index = -1;
      this.builder = new ObjectReferenceBuilder(this);
    }
    ObjectReferenceBuilder builder;
    Integer index;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.setToRelatedObjects(index,builder.build());
    }
    public N endRelatedObject() {
      return and();
    }
    
  }
  class VersionsNestedImpl<N> extends OperandVersionFluentImpl<ClusterOperatorStatusFluent.VersionsNested<N>> implements ClusterOperatorStatusFluent.VersionsNested<N>,Nested<N>{
    VersionsNestedImpl(Integer index,OperandVersion item) {
      this.index = index;
      this.builder = new OperandVersionBuilder(this, item);
    }
    VersionsNestedImpl() {
      this.index = -1;
      this.builder = new OperandVersionBuilder(this);
    }
    OperandVersionBuilder builder;
    Integer index;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.setToVersions(index,builder.build());
    }
    public N endVersion() {
      return and();
    }
    
  }
  
}