package io.fabric8.openshift.api.model.config.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class DNSSpecFluentImpl<A extends DNSSpecFluent<A>> extends BaseFluent<A> implements DNSSpecFluent<A>{
  public DNSSpecFluentImpl() {
  }
  public DNSSpecFluentImpl(DNSSpec instance) {
    this.withBaseDomain(instance.getBaseDomain()); 
    this.withPrivateZone(instance.getPrivateZone()); 
    this.withPublicZone(instance.getPublicZone()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private String baseDomain;
  private DNSZoneBuilder privateZone;
  private DNSZoneBuilder publicZone;
  private Map<String,Object> additionalProperties;
  public String getBaseDomain() {
    return this.baseDomain;
  }
  public A withBaseDomain(String baseDomain) {
    this.baseDomain=baseDomain; return (A) this;
  }
  public Boolean hasBaseDomain() {
    return this.baseDomain != null;
  }
  
  /**
   * This method has been deprecated, please use method buildPrivateZone instead.
   * @return The buildable object.
   */
  @Deprecated
  public DNSZone getPrivateZone() {
    return this.privateZone!=null ?this.privateZone.build():null;
  }
  public DNSZone buildPrivateZone() {
    return this.privateZone!=null ?this.privateZone.build():null;
  }
  public A withPrivateZone(DNSZone privateZone) {
    _visitables.get("privateZone").remove(this.privateZone);
    if (privateZone!=null){ this.privateZone= new DNSZoneBuilder(privateZone); _visitables.get("privateZone").add(this.privateZone);} else { this.privateZone = null; _visitables.get("privateZone").remove(this.privateZone); } return (A) this;
  }
  public Boolean hasPrivateZone() {
    return this.privateZone != null;
  }
  public DNSSpecFluent.PrivateZoneNested<A> withNewPrivateZone() {
    return new DNSSpecFluentImpl.PrivateZoneNestedImpl();
  }
  public DNSSpecFluent.PrivateZoneNested<A> withNewPrivateZoneLike(DNSZone item) {
    return new DNSSpecFluentImpl.PrivateZoneNestedImpl(item);
  }
  public DNSSpecFluent.PrivateZoneNested<A> editPrivateZone() {
    return withNewPrivateZoneLike(getPrivateZone());
  }
  public DNSSpecFluent.PrivateZoneNested<A> editOrNewPrivateZone() {
    return withNewPrivateZoneLike(getPrivateZone() != null ? getPrivateZone(): new DNSZoneBuilder().build());
  }
  public DNSSpecFluent.PrivateZoneNested<A> editOrNewPrivateZoneLike(DNSZone item) {
    return withNewPrivateZoneLike(getPrivateZone() != null ? getPrivateZone(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildPublicZone instead.
   * @return The buildable object.
   */
  @Deprecated
  public DNSZone getPublicZone() {
    return this.publicZone!=null ?this.publicZone.build():null;
  }
  public DNSZone buildPublicZone() {
    return this.publicZone!=null ?this.publicZone.build():null;
  }
  public A withPublicZone(DNSZone publicZone) {
    _visitables.get("publicZone").remove(this.publicZone);
    if (publicZone!=null){ this.publicZone= new DNSZoneBuilder(publicZone); _visitables.get("publicZone").add(this.publicZone);} else { this.publicZone = null; _visitables.get("publicZone").remove(this.publicZone); } return (A) this;
  }
  public Boolean hasPublicZone() {
    return this.publicZone != null;
  }
  public DNSSpecFluent.PublicZoneNested<A> withNewPublicZone() {
    return new DNSSpecFluentImpl.PublicZoneNestedImpl();
  }
  public DNSSpecFluent.PublicZoneNested<A> withNewPublicZoneLike(DNSZone item) {
    return new DNSSpecFluentImpl.PublicZoneNestedImpl(item);
  }
  public DNSSpecFluent.PublicZoneNested<A> editPublicZone() {
    return withNewPublicZoneLike(getPublicZone());
  }
  public DNSSpecFluent.PublicZoneNested<A> editOrNewPublicZone() {
    return withNewPublicZoneLike(getPublicZone() != null ? getPublicZone(): new DNSZoneBuilder().build());
  }
  public DNSSpecFluent.PublicZoneNested<A> editOrNewPublicZoneLike(DNSZone item) {
    return withNewPublicZoneLike(getPublicZone() != null ? getPublicZone(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    DNSSpecFluentImpl that = (DNSSpecFluentImpl) o;
    if (baseDomain != null ? !baseDomain.equals(that.baseDomain) :that.baseDomain != null) return false;
    if (privateZone != null ? !privateZone.equals(that.privateZone) :that.privateZone != null) return false;
    if (publicZone != null ? !publicZone.equals(that.publicZone) :that.publicZone != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(baseDomain,  privateZone,  publicZone,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (baseDomain != null) { sb.append("baseDomain:"); sb.append(baseDomain + ","); }
    if (privateZone != null) { sb.append("privateZone:"); sb.append(privateZone + ","); }
    if (publicZone != null) { sb.append("publicZone:"); sb.append(publicZone + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class PrivateZoneNestedImpl<N> extends DNSZoneFluentImpl<DNSSpecFluent.PrivateZoneNested<N>> implements DNSSpecFluent.PrivateZoneNested<N>,Nested<N>{
    PrivateZoneNestedImpl(DNSZone item) {
      this.builder = new DNSZoneBuilder(this, item);
    }
    PrivateZoneNestedImpl() {
      this.builder = new DNSZoneBuilder(this);
    }
    DNSZoneBuilder builder;
    public N and() {
      return (N) DNSSpecFluentImpl.this.withPrivateZone(builder.build());
    }
    public N endPrivateZone() {
      return and();
    }
    
  }
  class PublicZoneNestedImpl<N> extends DNSZoneFluentImpl<DNSSpecFluent.PublicZoneNested<N>> implements DNSSpecFluent.PublicZoneNested<N>,Nested<N>{
    PublicZoneNestedImpl(DNSZone item) {
      this.builder = new DNSZoneBuilder(this, item);
    }
    PublicZoneNestedImpl() {
      this.builder = new DNSZoneBuilder(this);
    }
    DNSZoneBuilder builder;
    public N and() {
      return (N) DNSSpecFluentImpl.this.withPublicZone(builder.build());
    }
    public N endPublicZone() {
      return and();
    }
    
  }
  
}