package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ImageContentPolicyListBuilder extends ImageContentPolicyListFluentImpl<ImageContentPolicyListBuilder> implements VisitableBuilder<ImageContentPolicyList,ImageContentPolicyListBuilder>{
  public ImageContentPolicyListBuilder() {
    this(false);
  }
  public ImageContentPolicyListBuilder(Boolean validationEnabled) {
    this(new ImageContentPolicyList(), validationEnabled);
  }
  public ImageContentPolicyListBuilder(ImageContentPolicyListFluent<?> fluent) {
    this(fluent, false);
  }
  public ImageContentPolicyListBuilder(ImageContentPolicyListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ImageContentPolicyList(), validationEnabled);
  }
  public ImageContentPolicyListBuilder(ImageContentPolicyListFluent<?> fluent,ImageContentPolicyList instance) {
    this(fluent, instance, false);
  }
  public ImageContentPolicyListBuilder(ImageContentPolicyListFluent<?> fluent,ImageContentPolicyList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ImageContentPolicyListBuilder(ImageContentPolicyList instance) {
    this(instance,false);
  }
  public ImageContentPolicyListBuilder(ImageContentPolicyList instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ImageContentPolicyListFluent<?> fluent;
  Boolean validationEnabled;
  public ImageContentPolicyList build() {
    ImageContentPolicyList buildable = new ImageContentPolicyList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}